# استخدام الثيم في أي مكان في المشروع

يمكنك الآن استخدام بيانات الثيم في أي مكان في المشروع باستخدام أحد الطرق التالية:

## استخدام دالة `theme()`

```php
// الحصول على بيانات لون معين
$primaryColor = theme('primary_color');

// الحصول على معلومة محددة مع قيمة افتراضية في حال عدم وجودها
$fontSize = theme('base_font_size', '14px');

// الحصول على كائن خدمة الثيم كاملاً
$themeService = theme();
```

## استخدام Facade مباشرة

```php
use Theme;

// الحصول على بيانات محددة
$primaryColor = Theme::get('primary_color');

// استعلام عن حالة الوضع الداكن
$isDarkMode = Theme::isDarkMode();

// الحصول على متغيرات CSS
$cssVariables = Theme::cssVariables();
```

## استخدام الدوال المساعدة المتخصصة

```php
// التحقق من حالة الوضع الداكن
if (is_dark_mode()) {
    // code for dark mode
}

// الحصول على نمط لعنصر معين
$sidebarStyle = theme_style('sidebar');
echo '<div style="' . $sidebarStyle . '">Sidebar Content</div>';

// الحصول على متغيرات CSS
$cssVariables = theme_css_variables();

// الحصول على قائمة الثيمات الجاهزة
$presets = theme_presets();

// الحصول على ثيم جاهز محدد
$bluePreset = theme_preset('blue_gradient');
```

## في ملفات Blade

يمكنك استخدام متغيرات CSS مباشرة في الستايلات:

```html
<div style="background-color: var(--primary-color); color: var(--text-color);">
    محتوى العنصر
</div>
```

أو استخدام متغير `$theme` المتاح في جميع الصفحات:

```blade
<div style="background-color: {{ $theme->primary_color }}; color: {{ $theme->text_color }};">
    محتوى العنصر
</div>
```

أو استخدام الدوال المساعدة:

```blade
<div style="{{ theme_style('heading') }}">
    عنوان بتنسيق الثيم
</div>

@if(is_dark_mode())
    <div class="dark-mode-content">محتوى للوضع الداكن</div>
@else
    <div class="light-mode-content">محتوى للوضع الفاتح</div>
@endif
```

## استخدام Config

يمكنك أيضًا استخدام البيانات من خلال Config:

```php
$themeData = config('theme');
$primaryColor = config('theme.primary_color');
```

## الثيمات الجاهزة

للحصول على قائمة الثيمات الجاهزة:

```php
$presets = config('theme.presets');
```

## تخصيص CSS

تم إضافة متغيرات CSS التالية لتسهيل تنسيق العناصر:

```css
:root {
    --sidebar-bg-color: #1e1e2d;
    --header-bg-color: #ffffff;
    --primary-color: #009ef7;
    --secondary-color: #E4E6EF;
    --text-color: #3F4254;
    --link-color: #009ef7;
    --font-family: 'Tajawal, Arial, sans-serif';
    --base-font-size: '14px';
    --heading-font-size: '1.25rem';
    --menu-font-size: '1rem';
}
```

استمتع باستخدام الثيم الخاص بك في أي مكان في المشروع بسهولة! 