<?php

namespace App\Exports;

use App\Models\Client;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ClientsExport implements FromQuery, WithHeadings
{
    public function query()
    {
        return Client::query()->with(['city', 'region']);
    }

    public function headings(): array
    {
        return [
            'ID',
            'First Name',
            'Last Name',
            'Birth Date',
            'Address',
            'Phone',
            'City',
            'Region',
            'Country Code',
            'Full Phone Number',
            'Gender',
            'Created At',
            'Updated At',
        ];
    }
}
