<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\Controller;
use App\Models\Client;
use App\Models\Examination;
use App\Models\Examiner;
use App\Models\User;
use App\Models\Invoice;
use App\Models\Payment;
use Carbon\Carbon;

class DashboardController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:dashboard-view', ['only' => ['index']]);
    }

    public function index(Request $request)
    {
        // العدادات الخاصة بالمستخدمين والعملاء والفحص
        $usersCount = User::count();
        $clientsCount = Client::count();
        $maleClientsCount = Client::where('gender', 'man')->count();
        $femaleClientsCount = Client::where('gender', 'women')->count();
        $examinersCount = Examiner::count();
        $examinationsCount = Examination::count();
        $examinationsTodayCount = Examination::whereDate('created_at', today())->count();
        $examinationsOperation = Examination::where('status', 'ارسال الي المشغل')->count();
        $examinationsWaiting = Examination::where('status', 'تم التجهيز')->count();
        $examinationsDone = Examination::where('status', 'تم الاستلام')->count();
        $examinationsCancelled = Examination::where('status', 'الغاء')->count();

        // إحصائيات المبيعات والفواتير
        $totalSales = 0;
        $totalInvoices = 0;
        $pendingPayments = 0;
        $monthlySales = [];

        // التحقق من وجود جدول الفواتير
        try {
            if (class_exists('App\Models\Invoice')) {
                $totalInvoices = Invoice::count();
                $totalSales = Invoice::sum('total_amount');
                $pendingPayments = Invoice::where('payment_status', 'pending')->sum('total_amount');

                // إحصائيات المبيعات الشهرية
                $startDate = Carbon::now()->subMonths(11)->startOfMonth();
                $endDate = Carbon::now()->endOfMonth();

                for ($date = $startDate; $date->lte($endDate); $date->addMonth()) {
                    $monthYear = $date->format('M');
                    $monthStart = Carbon::parse($date)->startOfMonth();
                    $monthEnd = Carbon::parse($date)->endOfMonth();

                    $monthlySales[$monthYear] = Invoice::whereBetween('created_at', [$monthStart, $monthEnd])
                        ->sum('total_amount');
                }
            }
        } catch (\Exception $e) {
            // لا يوجد جدول أو موديل للفواتير، نستمر بدونه
        }

        // الفحوصات اليوم والفحوصات التي تم استلامها
        $examinationsToday = Examination::whereDate('created_at', today())->get();
        $examinationsRecievedDone = Examination::where('status', 'تم الاستلام')->get();

        // جلب جميع الفحوصات وحالات الفحص الفريدة مع الفلاتر
        $examinations = Examination::query();

        if ($request->filled('search')) {
            $examinations->where('code', 'like', '%' . $request->search . '%');
        }

        if ($request->filled('status')) {
            $examinations->where('status', $request->status);
        }

        if ($request->filled('from_date')) {
            $examinations->whereDate('created_at', '>=', $request->from_date);
        }

        if ($request->filled('to_date')) {
            $examinations->whereDate('created_at', '<=', $request->to_date);
        }

        // جلب الفحوصات مع التصفية
        $examinations = $examinations->get();

        // جلب حالات الفحص الفريدة
        $statuses = Examination::distinct()->pluck('status');

        // تمرير البيانات إلى الـ view
        return view('admin.index', compact(
            'usersCount',
            'clientsCount',
            'examinersCount',
            'examinationsCount',
            'examinationsTodayCount',
            'examinationsOperation',
            'examinationsWaiting',
            'examinationsDone',
            'examinationsCancelled',
            'examinationsToday',
            'examinationsRecievedDone',
            'maleClientsCount',
            'femaleClientsCount',
            'examinations',
            'statuses',
            'totalSales',
            'totalInvoices',
            'pendingPayments',
            'monthlySales'
        ));
    }

    public function setLocale(Request $request)
    {
        $locale = $request->input('locale');

        if (in_array($locale, ['en', 'ar'])) {
            Session::put('locale', $locale);
            App::setLocale($locale);
        }

        return redirect()->back();
    }
}
