<?php

namespace App\Http\Controllers\Admin;

use Carbon\Carbon;
use App\Models\Data;
use App\Models\Room;
use App\Models\Client;
use App\Models\Examiner;
use App\Models\Examination;
use Illuminate\Http\Request;
use App\Jobs\SendWhatsappMessage;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DelayedDeliveriesController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:delayed-deliveries-list', ['only' => ['index']]);
        $this->middleware('permission:delayed-deliveries-create', ['only' => ['create', 'store']]);
        $this->middleware('permission:delayed-deliveries-edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:delayed-deliveries-delete', ['only' => ['destroy']]);
    }

    // Display a listing of the delayed with examination status "ارسال الي المشغل"
    public function index()
    {
        // تحديد التاريخ الحالي وطرح 30 يوم
        $thirtyDaysAgo = Carbon::now()->subDays(30);

        // استرجاع الفحوصات التي تجاوزت 30 يومًا
        $examinations = Examination::with('client')
            ->where('status', 'تم التجهيز')
            ->where('created_at', '<', $thirtyDaysAgo) // الفحص الذي تم إنشاؤه قبل أكثر من 30 يومًا
            ->latest()
            ->get();

        return view('admin.delayedDelivery.index', compact('examinations'));
    }




    public function show($id)
    {
        // الحصول على السجل الذي نريد تعديله مع تفاصيله
        $examination = Examination::with('details')->findOrFail($id);

        // استرجاع البيانات الأخرى (العملاء، الفاحصين، الأنواع)
        $clients = Client::all();
        $examiners = Examiner::all();
        $types = ['نظارات', 'عدسات']; // أو يمكنك استرجاع الأنواع من قاعدة البيانات إذا كانت متغيرة

        // تمرير البيانات إلى صفحة العرض
        return view('admin.delayedDelivery.show', compact('examination', 'clients', 'examiners', 'types'));
    }









    // public function updateStatus(Request $request, $id)
    // {
    //     // العثور على الفحص بواسطة الـ ID مع تضمين العميل
    //     $examination = Examination::with('client')->findOrFail($id);

    //     // تحديث حالة الفحص
    //     $examination->status = $request->input('status');
    //     $examination->save();

    //     // التحقق من نجاح عملية الحفظ
    //     if ($examination->wasChanged()) {
    //         // إرسال الـ Job إلى الـ Queue مباشرة بعد تحديث الحالة
    //         SendWhatsappMessage::dispatch($examination);

    //         // العودة إلى صفحة الاستقبال مع رسالة نجاح
    //         return redirect()->route('admin.delayed.index')->with('success', 'تم تحديث الحالة بنجاح. سيتم إرسال رسالة WhatsApp قريباً.');
    //     }

    //     // العودة إلى صفحة الاستقبال مع رسالة نجاح إذا لم يكن هناك تغيير
    //     return redirect()->route('admin.delayed.index')->with('success', 'تم تحديث الحالة بنجاح.');
    // }

    public function updateStatus(Request $request, $id)
    {
        // العثور على الفحص باستخدام الـ ID
        $examination = Examination::findOrFail($id);

        // تحديث الحالة فقط إذا تم إرسالها في الـ request
        if ($request->has('status')) {
            $examination->status = $request->input('status');
        }

        // إضافة أي تحديثات أخرى على الـ Examination إذا كان هناك المزيد من الحقول.
        // مثال:
        // if ($request->has('other_field')) {
        //    $examination->other_field = $request->input('other_field');
        // }

        // حفظ التغييرات
        $examination->save();

        // تحقق إذا كانت الحالة قد تغيرت فعلاً
        if ($examination->wasChanged()) {
            // إرسال رسالة WhatsApp عبر الـ Queue فقط إذا كانت الحالة قد تغيرت
            SendWhatsappMessage::dispatch($examination);

            return redirect()->route('admin.delayed-deliveries.index')->with('success', 'تم تحديث الحالة وسيتم إرسال رسالة WhatsApp.');
        }

        // إذا لم تتغير الحالة
        return redirect()->route('admin.delayed-deliveries.index')->with('info', 'الحالة لم تتغير.');
    }


    public function updateSpecial(Request $request, $id)
    {
        // العثور على الفحص باستخدام الـ ID
        $examination = Examination::findOrFail($id);
        // تحديث حقل `special` فقط إذا تم إرساله في الـ request
        if ($request->has('special')) {
            $examination->special = $request->input('special');
        }
        // حفظ التغييرات
        $examination->save();
        // إذا لم تتغير القيمة
        return redirect()->route('admin.delayed-deliveries.index')->with('success', 'تم تحديث نوع الفحص بنجاح');
    }



    public function print($id)
    {
        $examination = Examination::with(['client', 'examiner'])->findOrFail($id);
        return view('admin.delayedDelivery.print', compact('examination'));
    }

    public function printSpecial($id)
    {
        $examination = Examination::with(['client', 'examiner'])->findOrFail($id);
        $specials = ['عادي', 'مميز', 'مستعجل', 'تحضير', 'توصيل'];

        // تأكد من أن الفحص مميز
        if ($examination->special) {
            return view('admin.delayedDelivery.print_special', compact('examination','specials'));
        } else {
            return view('admin.delayedDelivery.print', compact('examination','specials'));
        }
    }
}
