<?php

namespace App\Http\Controllers\Admin;

use App\Models\Data;
use App\Models\Room;
use App\Models\Client;
use App\Models\Examiner;
use App\Models\Whatsapp;
use App\Models\Reception;
use App\Models\Examination;
use Illuminate\Http\Request;
use App\Models\WhatsAppTemplate;
use App\Services\WhatsAppService;
use App\Models\Examination_detail;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class ExaminationsController extends Controller
{

    protected $whatsAppService;


    public function __construct(WhatsAppService $whatsAppService)
    {
        $this->middleware('permission:examinations-list', ['only' => ['index']]);
        $this->middleware('permission:examinations-create', ['only' => ['create', 'store']]);
        $this->middleware('permission:examinations-edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:examinations-delete', ['only' => ['destroy']]);
        $this->whatsAppService = $whatsAppService;
    }
    // Display a listing of the examinations for today
    public function index()
    {
        // Fetch examinations created today with related client data
        $examinations = Examination::with('client')
            ->whereDate('created_at', today())
            ->where('make_from', 'examinations')
            ->get();
        // return $examinations ;

        return view('admin.examinations.index', compact('examinations'));
    }

    public function create()
    {
     $user = Auth::user();
        $group=room::where('room_code',$user->room_code)->pluck('group')->first();

        // Fetch the data based on room_code
        $data = Data::where('room_code', $user->room_code)->get();

        $rooms = Room::all();
        $formatted_data = [];

        foreach ($data as $item) {
            // Corrected regex
            $regex = '/[RL]\s+\$\s+([+-]?)\s*\$\s*(\d+\.\d+)\s*\$\s*([+-]?)\s*\$\s*(\d+\.\d+)\s*\$\s*(\d+)/';

            // Parse data_rt
            if (preg_match($regex, $item->data_rt, $matches_rt)) {
                $formatted_rt = [
                    'type' => 'R',
                    'sph' => ($matches_rt[1] ?? '') . $matches_rt[2],
                    'cyl' => ($matches_rt[3] ?? '') . $matches_rt[4],
                    'axis' => $matches_rt[5],
                    'lpd' => $item->lpd_rt ?? 'N/A',
                    'add' => $item->add_rt ?? 'N/A',
                ];
            } else {
                $formatted_rt = [
                    'type' => 'R',
                    'sph' => 'N/A',
                    'cyl' => 'N/A',
                    'axis' => 'N/A',
                    'lpd' => $item->lpd_rt ?? 'N/A',
                    'add' => $item->add_rt ?? 'N/A',
                ];
            }

            // Parse data_lt
            if (preg_match($regex, $item->data_lt, $matches_lt)) {
                $formatted_lt = [
                    'type' => 'L',
                    'sph' => ($matches_lt[1] ?? '') . $matches_lt[2],
                    'cyl' => ($matches_lt[3] ?? '') . $matches_lt[4],
                    'axis' => $matches_lt[5],
                    'lpd' => $item->lpd_lt ?? 'N/A',
                    'add' => $item->add_lt ?? 'N/A',
                ];
            } else {
                $formatted_lt = [
                    'type' => 'L',
                    'sph' => 'N/A',
                    'cyl' => 'N/A',
                    'axis' => 'N/A',
                    'lpd' => $item->lpd_lt ?? 'N/A',
                    'add' => $item->add_lt ?? 'N/A',
                ];
            }

            // Collect formatted data
            $formatted_data[] = [
                'id' => $item->id,
                'room_code' => $item->room_code,
                'right_eye' => $formatted_rt,
                'left_eye' => $formatted_lt,
            ];
        }
        // return $formatted_data ;

        // return $formatted_data ;
        // Fetch other required data for the view
         $clients = Client::orderBy('created_at', 'desc')->get();


        $types = ['نظارات', 'عدسات']; // Example types
        
$lastExamination = Examination::
    // where('make_from', 'receptions')
      where('group', $group)
    ->latest('id')
    ->first();

    //  return $lastExamination ; 
if ($lastExamination) {
    $lastCodeNumber = (int) substr($lastExamination->code, 2); // Extract numeric part after 'E-'
    if ($lastCodeNumber >= 300) {
        $examination_code = $group.'-'. str_pad(1, 3, '0', STR_PAD_LEFT); // Reset to 1 if greater than or equal to 300
    } else {
        $examination_code = $group.'-'. str_pad($lastCodeNumber + 1, 3, '0', STR_PAD_LEFT);
    }
} else {
    $examination_code = '$group'.'-'. str_pad(1, 3, '0', STR_PAD_LEFT); // Default code if no records exist
}

        $examiners = Examiner::all();

        // Return the formatted data along with the rest of the information to the view
        return view('admin.examinations.create', compact('clients', 'types', 'examination_code', 'examiners', 'formatted_data', 'rooms'));
    }

    public function fetchLastExamination(Request $request)
    {
        $clientId = $request->input('client_id');

        // Validate that client_id is provided
        if (!$clientId) {
            return response()->json(['message' => __('translations.client_id_required')], 400);
        }

        // Check if the client exists
        $client = Client::find($clientId);
        if (!$client) {
            return response()->json(['message' => __('translations.client_not_found')], 404);
        }

        // Retrieve the latest examination for the client
        $examination = Examination::where('client_id', $clientId)->latest()->first();
        if (!$examination) {
            return response()->json(['message' => __('translations.no_examinations_found')], 404);
        }

        // Retrieve the details for the latest examination
        $lastExamination = Examination_detail::where('examination_id', $examination->id)->get();
        if ($lastExamination->isEmpty()) {
            return response()->json(['message' => __('translations.no_examination_details_found')], 404);
        }

        // Return the combined data
        return response()->json([
            'client' => $client,
            'examination' => $examination,
            'details' => $lastExamination
        ]);
    }



    public function sateAjax()
    {
        $user = Auth::user();
        $data = Data::where('room_code', $user->room_code)->get();


        $formatted_data = [];

        foreach ($data as $item) {
            // Corrected regex
            $regex = '/[RL]\s+\$\s+([+-]?)\s*\$\s*(\d+\.\d+)\s*\$\s*([+-]?)\s*\$\s*(\d+\.\d+)\s*\$\s*(\d+)/';
            // return $item ;
            // Parse data_rt
            if (preg_match($regex, $item->data_rt, $matches_rt)) {
                $formatted_rt = [
                    'type' => 'R',
                    'sph' => ($matches_rt[1] ?? '') . $matches_rt[2],
                    'cyl' => ($matches_rt[3] ?? '') . $matches_rt[4],
                    'axis' => $matches_rt[5],
                    'lpd' => $item->lpd_rt ?? 'N/A',
                    'add' => $item->add_rt ?? 'N/A',
                ];
            } else {
                $formatted_rt = [
                    'type' => 'R',
                    'sph' => 'N/A',
                    'cyl' => 'N/A',
                    'axis' => 'N/A',
                    'lpd' => $item->lpd_rt ?? 'N/A',
                    'add' => $item->add_rt ?? 'N/A',
                ];
            }

            // Parse data_lt
            if (preg_match($regex, $item->data_lt, $matches_lt)) {
                $formatted_lt = [
                    'type' => 'L',
                    'sph' => ($matches_lt[1] ?? '') . $matches_lt[2],
                    'cyl' => ($matches_lt[3] ?? '') . $matches_lt[4],
                    'axis' => $matches_lt[5],
                    'lpd' => $item->lpd_lt ?? 'N/A',
                    'add' => 0 ?? '0',
                ];
            } else {
                $formatted_lt = [
                    'type' => 'L',
                    'sph' => 'N/A',
                    'cyl' => 'N/A',
                    'axis' => 'N/A',
                    'lpd' => $item->lpd_lt ?? 'N/A',
                    'add' =>  0 ?? '0',
                ];
            }

            // Collect formatted data
            $formatted_data[] = [
                'id' => $item->id,
                'room_code' => $item->room_code,
                'right_eye' => $formatted_rt,
                'left_eye' => $formatted_lt,
            ];
        }

        return response()->json($formatted_data);
    }

    // Store a newly created examination in storage
    public function store(Request $request)
    {
         $user = Auth::user();
        $group=room::where('room_code',$user->room_code)->pluck('group')->first();
        // Validate the incoming request
        $request->validate([
            'code'        => 'required',
            'notes'       => 'nullable|string|max:255',

            'type'        => 'required|string',
            'client_id'   => 'required|exists:clients,id',
            'examiner_id' => 'required|exists:examiners,id',
        ]);

        // Prepare examination data
        $requestData = $request->only([ 'notes', 'type', 'client_id', 'examiner_id','code']);
        $requestData['status'] = 'في انتظار التاكيد'; // Default status
        $requestData['make_from'] = 'examinations';
         $requestData['group'] = $group;
        //   $requestData['code'] = $examination_code;
        $requestData['create_by'] = auth()->user()->id;

        $requestData['special'] = 'عادي'; // تعيين الخاصية إلى false بشكل افتراضي

        // Create the examination record
        $examination = Examination::create($requestData);

        // Process the 'data' field if it exists
        if ($request->has('data') && is_array($request->data)) {
            foreach ($request->data as $item) {
                // Create examination detail for the right eye
                Examination_detail::create([
                    'sph'            => $item['right_eye']['sph'] ?? 'N/A',
                    'cyl'            => $item['right_eye']['cyl'] ?? 'N/A',
                    'axis'           => $item['right_eye']['axis'] ?? 'N/A',
                    'lpd'            => $item['right_eye']['lpd'] ?? 'N/A',
                    'add'            => $item['right_eye']['add'] ?? 'N/A',
                    'type'           => 'R', // Right eye
                    'examination_id' => $examination->id,
                ]);

                // Create examination detail for the left eye
                Examination_detail::create([
                    'sph'            => $item['left_eye']['sph'] ?? 'N/A',
                    'cyl'            => $item['left_eye']['cyl'] ?? 'N/A',
                    'axis'           => $item['left_eye']['axis'] ?? 'N/A',
                    'lpd'            => $item['left_eye']['lpd'] ?? 'N/A',
                    'add'            => $item['left_eye']['add'] ?? 'N/A',
                    'type'           => 'L', // Left eye
                    'examination_id' => $examination->id,
                ]);
            }
        }

        // Delete related data if provided
        if ($request->has('data.0.id')) {
            foreach ($request->data as $item) {
                if (isset($item['id'])) {
                    Data::where('id', $item['id'])->delete();
                }
            }
        }

       
        return redirect()->route('admin.examinations.show', $examination->id)->with('success', 'تم إضافة الفحص بنجاح.');
    }







    public function show(int $id)
    {
        $user = Auth::user();
        $examination = Examination::where('id', $id)->with('details')->first();
        $client = $examination->client;
        $clients = Client::all(); // Fetch all clients
        $types = ['نظارات', 'عدسات']; // Example types
        $examiners = Examiner::all();
        // return $examination ;
        return view('admin.examinations.show', compact('examination', 'client', 'clients', 'types', 'examiners'));
    }



    public function edit(int $id)
    {
        // Retrieve the examination record by its ID, including related details
        $examination = Examination::where('id', $id)->with('details')->first();
        $client = $examination->client;

        // Fetch the data based on room_code for the specific examination
        $user = Auth::user();
        $data = Data::where('room_code', $user->room_code)->get();


        // Prepare an array to hold formatted data
        $formatted_data = [];

        // Format the data as needed (similar to the create method)
        foreach ($data as $item) {
            // Parse the right eye (data_rt)
            preg_match('/R\s*-\s*-\s*-\s*(\d+\.\d+)\s*-\s*-\s*-\s*(\d+\.\d+)\s*-\s*(\d+)/', $item->data_rt, $matches_rt);
            $formatted_rt = [
                'type' => 'R',
                'sph' => $matches_rt[1] ?? 'N/A',  // SPH: -4.50
                'cyl' => $matches_rt[2] ?? 'N/A',  // CYL: -1.00
                'axis' => $matches_rt[3] ?? 'N/A', // Axis: 175
                'lpd' => $item->lpd_rt ?? 'N/A',   // Lens Power Difference for right eye
                'add' => $item->add_rt ?? 'N/A',   // Addition for right eye
            ];

            // Parse the left eye (data_lt)
            preg_match('/L\s*-\s*-\s*-\s*(\d+\.\d+)\s*-\s*-\s*-\s*(\d+\.\d+)\s*-\s*(\d+)/', $item->data_lt, $matches_lt);
            $formatted_lt = [
                'type' => 'L',
                'sph' => $matches_lt[1] ?? 'N/A',  // SPH: -4.25
                'cyl' => $matches_lt[2] ?? 'N/A',  // CYL: -1.75
                'axis' => $matches_lt[3] ?? 'N/A', // Axis: 170
                'lpd' => $item->lpd_lt ?? 'N/A',   // Lens Power Difference for left eye
                'add' => $item->add_lt ?? 'N/A',   // Addition for left eye
            ];

            // Collect formatted data for each item
            $formatted_data[] = [
                'id' => $item->id,
                'room_code' => $item->room_code,
                'right_eye' => $formatted_rt,
                'left_eye' => $formatted_lt,
            ];
        }

        // Fetch other required data for the view
        $clients = Client::all(); // Fetch all clients
        $types = ['نظارات', 'عدسات']; // Example types
        $examiners = Examiner::all();

        // Return the formatted data along with the rest of the information to the view
        return view('admin.examinations.edit', compact('examination', 'client', 'clients', 'types', 'examiners', 'formatted_data'));
    }




    // Update the specified examination in storage
    public function update(Request $request, int $id)
    {
        // استرجاع السجل بناءً على ID الفحص
        $examination = Examination::findOrFail($id);

        // التحقق من صحة البيانات المدخلة
        $validatedData = $request->validate([
            'client_id' => 'required|exists:clients,id',
            'examination_date' => 'required|date',
            // إضافة قواعد التحقق الأخرى حسب الحاجة
        ]);

        // تحديث بيانات الفحص
        $examination->update([
            'client_id' => $validatedData['client_id'],
            'examination_date' => $validatedData['examination_date'],
            'update_by' => auth()->user()->id,  // تسجيل آخر مستخدم قام بالتحديث
        ]);

        // تحقق إذا كان هناك تفاصيل العينين
        if ($request->has('formatted_data')) {
            // مسح التفاصيل القديمة
            Examination_detail::where('examination_id', $examination->id)->delete();

            // حفظ التفاصيل الجديدة
            foreach ($request->formatted_data as $item) {
                // التأكد من أن كل الحقول موجودة
                $rightEye = $item['right_eye'] ?? [];
                $leftEye = $item['left_eye'] ?? [];

                // حفظ تفاصيل العين اليمنى
                Examination_detail::create([
                    'sph'            => $rightEye['sph'] ?? 'N/A',
                    'cyl'            => $rightEye['cyl'] ?? 'N/A',
                    'axis'           => $rightEye['axis'] ?? 'N/A',
                    'lpd'            => $rightEye['lpd'] ?? 'N/A',
                    'add'            => $rightEye['add'] ?? 'N/A',
                    'type'           => 'R',  // العين اليمنى
                    'examination_id' => $examination->id,
                ]);

                // حفظ تفاصيل العين اليسرى
                Examination_detail::create([
                    'sph'            => $leftEye['sph'] ?? 'N/A',
                    'cyl'            => $leftEye['cyl'] ?? 'N/A',
                    'axis'           => $leftEye['axis'] ?? 'N/A',
                    'lpd'            => $leftEye['lpd'] ?? 'N/A',
                    'add'            => $leftEye['add'] ?? 'N/A',
                    'type'           => 'L',  // العين اليسرى
                    'examination_id' => $examination->id,
                ]);
            }
        }

        // إعادة التوجيه مع رسالة نجاح
        return redirect()->route('admin.examinations.index')->with('success', 'تم تحديث الفحص بنجاح.');
    }





    // Remove the specified examination from storage
    public function destroy(int $id)
    {
        $examination = Examination::findOrFail($id);

        // Optionally, delete related examination details
        Examination_detail::where('examination_id', $id)->delete();

        $examination->delete();

        session()->flash('success', __('messages.delete'));
        return redirect()->route('admin.examinations.index');
    }
    public function updateStatusForm($id)
    {
        // جلب الفحص حسب الـ ID
        $examination = Examination::findOrFail($id);

        // تعريف الحالات المتاحة
        $statuses = ['في انتظار التاكيد', 'ارسال الي المشغل', 'تم الجهيز', 'تم الاستلام', 'الغاء'];

        // عرض صفحة اختيار الحالة
        return view('admin.examinations.update-status', compact('examination', 'statuses'));
    }

    public function updateStatus(Request $request, $id)
    {
        // جلب الفحص باستخدام الـ ID
        $examination = Examination::findOrFail($id);

        // تحديث حالة الفحص
        $examination->status = $request->input('status');
        $examination->save();

        // إعادة التوجيه مع رسالة نجاح
        return redirect()->route('admin.examinations.index')->with('success', 'تم تحديث الحالة بنجاح');
    }

    public function confirmExamination($id)
    {
        $examination = Examination::findOrFail($id);
        $examination->status = 'تم التأكيد'; // أو حالة أخرى إذا أردت
        $examination->save();

        return redirect()->route('admin.receptions.index')->with('success', 'تم تأكيد الفحص وإرساله إلى الاستقبال');
    }

    public function updateStatusInline(Request $request, $id)
    {
        $request->validate([
            'status' => 'required|string',
        ]);

        $examination = Examination::findOrFail($id);
        $examination->status = $request->input('status');
        $examination->update_by = auth()->user()->id; // المستخدم الذي قام بالتعديل
        $examination->save();

        return redirect()->back()->with('success', 'تم تحديث الحالة بنجاح');
    }

    public function updateCategoryInline(Request $request, $id)
    {
        $request->validate([
            'category' => 'required|string',
        ]);

        $examination = Examination::findOrFail($id);
        $examination->category = $request->input('category');
        $examination->update_by = auth()->user()->id; // المستخدم الذي قام بالتعديل
        $examination->save();


        return redirect()->back()->with('success', 'تم تحديث الحالة بنجاح');
    }

    public function data(Request $request)
    {
        // Step 1: Validation of incoming data
        $validatedData = $request->validate([
            'data_rt' => 'required|string', // validated for right side data
            'data_lt' => 'required|string', // validated for left side data
            'lpd_rt' => 'required|string', // validated for right side LPD
            'lpd_lt' => 'required|string', // validated for left side LPD
            'add_rt' => 'required|string', // validated for right side ADD
            'add_lt' => 'required|string', // validated for left side ADD
            'room_code' => 'required|exists:rooms,room_code', // Ensure room_code is validated against the correct field in rooms table
        ]);

        // If validation passes, continue with the following steps
        try {
            // Step 2: Find the room using the validated room_code
            $room = Room::where('room_code', $validatedData['room_code'])->first();

            if (!$room) {
                return response()->json([
                    'success' => false,
                    'error' => 'Room with this code does not exist.'
                ], 404);
            }

            // Step 3: Check if there's existing data for the room, and get the latest one
            $existingData = Data::where('room_code', $room->room_code)
                ->latest() // Get the most recent data entry
                ->first(); // Get only the most recent record

            if ($existingData) {
                // If there's already data, update it with the new values
                $existingData->data_rt = $validatedData['data_rt'];
                $existingData->data_lt = $validatedData['data_lt'];
                $existingData->lpd_rt = $validatedData['lpd_rt'];
                $existingData->lpd_lt = $validatedData['lpd_lt'];
                $existingData->add_rt = $validatedData['add_rt'];
                $existingData->add_lt = $validatedData['add_lt'];
                $existingData->save(); // Save the updated data
                $data = $existingData; // Set the updated data to return
            } else {
                // If no data exists, create a new data entry
                $data = new Data();
                $data->data_rt = $validatedData['data_rt']; // Store the right side data
                $data->data_lt = $validatedData['data_lt']; // Store the left side data
                $data->lpd_rt = $validatedData['lpd_rt'];   // Store the right side LPD
                $data->lpd_lt = $validatedData['lpd_lt'];   // Store the left side LPD
                $data->add_rt = $validatedData['add_rt'];   // Store the right side ADD
                $data->add_lt = $validatedData['add_lt'];   // Store the left side ADD
                $data->room_code = $room->room_code;        // Store the room_code from the room table
                $data->save(); // Save the new data
            }

            // Step 4: Return the created or updated data as a JSON response
            return response()->json([
                'success' => true,
                'message' => 'تم تحديث الحالة بنجاح',
                'data' => $data
            ], 200); // 200 OK status code
        } catch (\Exception $e) {
            // Handle any exceptions that might occur during saving
            return response()->json([
                'success' => false,
                'error' => 'حدث خطأ أثناء حفظ البيانات: ' . $e->getMessage()
            ], 500); // 500 Internal Server Error status code
        }
    }


    // Custom error handling for validation exceptions
    public function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        // You can customize the response format or message here
        $errors = $validator->errors()->all();

        return response()->json([
            'success' => false,
            'error' => 'Validation failed',
            'messages' => $errors
        ], 422); // 422 Unprocessable Entity status code
    }




    public function print($id)
    {
        // Retrieve the examination record by its ID with related client, examiner, and details
        $examination = Examination::with(['client', 'examiner', 'details'])->findOrFail($id);

        $client = $examination->client;
        $user = Auth::user();
        $clients = Client::all();
        $types = ['نظارات', 'عدسات'];
        $examiners = Examiner::all();

        // Return the formatted data along with the rest of the information to the print view
        return view('admin.examinations.print', compact('examination', 'client', 'clients', 'types', 'examiners'));
    }





    public function delayed() {}
}
