<?php

namespace App\Http\Controllers\Admin;

use App\Models\Role;
use App\Http\Controllers\Controller;
use App\Models\Examiner;
use Illuminate\Http\Request;

class ExaminersController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:examiners-list', ['only' => ['index']]);
        $this->middleware('permission:examiners-create', ['only' => ['create', 'store']]);
        $this->middleware('permission:examiners-edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:examiners-delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $examiners = Examiner::with('roles')->get();
        return view('admin.examiners.index', compact('examiners'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $roles = Role::all();
        return view('admin.examiners.create', compact('roles'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'     => 'required',
            'age'     => 'required',
            'email'    => 'required|email:filter|unique:examiners,email',
            'phone'    => 'required|unique:examiners,phone',
            'address'  => 'nullable',
            'role'     => 'required',
        ]);


        $examiner = Examiner::create([
            'name'     => $request->name,
            'age'     => $request->age,
            'email'    => $request->email,
            'phone'    => $request->phone,
            'address'  => $request->address,
        ]);

        $examiner->addRole($request->role);

        session()->flash('success', __('messages.create'));
        return redirect()->route('admin.examiners.index');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    public function edit(int $id) {
        $roles = Role::all();
        $examiner = Examiner::findOrFail($id);
        return view('admin.examiners.edit', compact('roles', 'examiner'));
    }

    public function update(Request $request, int $id) {
        $examiner = Examiner::findOrFail($id);

        $request->validate([
            'name'     => 'required',
            'age'     => 'required',
            'email'    => 'required|email:filter|unique:examiners,email,'.$examiner->id,
            'role'     => 'required',
            'phone'    => 'required|unique:examiners,phone,'.$examiner->id,
            'address'  => 'nullable',
        ]);

        $examiner->update([
            'name'     => $request->name,
            'age'     => $request->age,
            'email'    => $request->email,
            'phone'    => $request->phone,
            'address'  => $request->address,
        ]);

        $examiner->roles()->sync([]);
        $examiner->addRole($request->role);

        session()->flash('success', __('messages.update'));
        return redirect()->route('admin.examiners.index');
    }

    public function destroy(int $id) {
        $examiner = Examiner::findOrFail($id);
        $examiner->roles()->sync([]);
        $examiner->delete();

        session()->flash('success', __('messages.delete'));
        return redirect()->route('admin.examiners.index');
    }
}
