<?php

namespace App\Http\Controllers\Admin;

use App\Models\Client;
use App\Models\Examiner;
use App\Models\Examination;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class RecievedController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:recieveds-list', ['only' => ['index']]);
        $this->middleware('permission:recieveds-create', ['only' => ['create', 'store']]);
        $this->middleware('permission:recieveds-edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:recieveds-delete', ['only' => ['destroy']]);
    }

    // Display a listing of the recieveds with examination status "ارسال الي المشغل"
    public function index()
    {

        $examinations = Examination::with('client', 'recieveds')
            ->where('status', 'تم الاستلام')
            ->get();

        // Pass the filtered examinations to the view
        return view('admin.recieveds.index', compact('examinations'));
    }




    public function show($id)
    {
        // الحصول على السجل الذي نريد تعديله مع تفاصيله
        $examination = Examination::with('details')->findOrFail($id);

        // استرجاع البيانات الأخرى (العملاء، الفاحصين، الأنواع)
        $clients = Client::all();
        $examiners = Examiner::all();
        $types = ['نظارات', 'عدسات']; // أو يمكنك استرجاع الأنواع من قاعدة البيانات إذا كانت متغيرة

        // تمرير البيانات إلى صفحة العرض
        return view('admin.recieveds.show', compact('examination', 'clients', 'examiners', 'types'));
    }




    public function updateStatusForm($id)
    {
        // جلب الفحص حسب الـ ID
        $examination = Examination::findOrFail($id);
        // تعريف الحالات المتاحة
        $statuses = ['في انتظار التاكيد', 'ارسال الي المشغل', 'تم الجهيز', 'تم الاستلام', 'الغاء'];

        return view('admin.recieveds.update-status', compact('examination', 'statuses'));
    }

    public function updateStatus(Request $request, $id)
    {
        // جلب الفحص باستخدام الـ ID
        $examination = Examination::findOrFail($id);

        // التحقق من وجود الحالة
        if ($request->has('status')) {
            $examination->status = $request->input('status');
            $examination->save();
        }

        // إرسال استجابة JSON إلى العميل
        return response()->json([
            'success' => true,
            'status' => $examination->status, // إرسال الحالة الجديدة
        ]);
    }


    public function updateSpecial(Request $request, $id)
    {
        // العثور على الفحص باستخدام الـ ID
        $examination = Examination::findOrFail($id);
        // تحديث حقل `special` فقط إذا تم إرساله في الـ request
        if ($request->has('special')) {
            $examination->special = $request->input('special');
        }
        // حفظ التغييرات
        $examination->save();
        // إذا لم تتغير القيمة
        return redirect()->route('admin.recieveds.index')->with('success', 'تم تحديث نوع الفحص بنجاح');
        
    }
}
