<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Room;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class RoomController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:rooms-list', ['only' => ['index']]);
        $this->middleware('permission:rooms-create', ['only' => ['create', 'store']]);
        $this->middleware('permission:rooms-edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:rooms-delete', ['only' => ['destroy']]);
    }
    public function index()
    {
        $rooms = Room::all();
        return view('admin.rooms.index', compact('rooms'));
    }
    public function create()
    {
        return view('admin.rooms.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name'      => 'required|string|max:255',
            'room_code' => 'required|string',
        ]);

        Room::create([
            'name'      => $request->name,
            'room_code' => $request->room_code,
        ]);

        session()->flash('success', __('messages.create'));
        return redirect()->route('admin.rooms.index');
    }

    public function edit(int $id)
    {
        $room = Room::findOrFail($id);

        return view('admin.rooms.edit', compact('room'));
    }

    // Update the specified examination in storage
    public function update(Request $request, int $id)
    {
        $room = Room::findOrFail($id);

        $request->validate([
            'name'       => 'required|string|max:255',
            'room_code'  => 'required|string',
        ]);

        $room->update([
            'name'      => $request->name,
            'room_code' => $request->room_code,
        ]);

        session()->flash('success', __('messages.update'));
        return redirect()->route('admin.rooms.index');
    }

    public function destroy(int $id)
    {
        $room = Room::findOrFail($id);
        $room->delete();

        session()->flash('success', __('messages.deleted'));
        return redirect()->route('admin.rooms.index');
    }
}
