<?php

namespace App\Http\Controllers\Admin;

use App\Models\Settings;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Whatsapp;
use App\Models\Invotek;
class SettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:settings', ['only' => ['index']]);
    }

    public function all()
    {
        return view('admin.setting-management');
    }
    public function index()
    {
        return view('admin.settings.index');
    }

    public function update(Request $request)
    {
        $request->validate([
            'email'          => 'required|string|max:255',
            'phone1'         => 'required',
            'phone2'         => 'required',
            'name_ar'        => 'required|string|max:255',
            'name_en'        => 'required|string|max:255',
            'address_ar'     => 'required|string|max:255',
            'address_en'     => 'required|string|max:255',
            'description_ar' => 'required|string',
            'description_en' => 'required|string',
            'logo'           => 'nullable|image',
        ]);

        $setting = Settings::first();

        $picturePath = $setting->logo;
        if ($request->hasFile('logo')) {
            // تحقق مما إذا كان الملف القديم موجودًا قبل محاولة حذفه
            if ($setting->logo && file_exists('uploads/' . $setting->logo)) {
                unlink('uploads/' . $setting->logo); // حذف الشعار القديم إذا كان موجودًا
            }

            // حفظ الشعار الجديد
            $pictureName = rand() . '.' . $request->file('logo')->getClientOriginalExtension();
            $picturePath = $request->file('logo')->storeAs('', $pictureName, 'custom_path');
        }

        // تحديث الإعدادات بالقيم الجديدة
        $setting->email = $request->email;
        $setting->phone1 = $request->phone1;
        $setting->phone2 = $request->phone2;
        $setting->translateOrNew('ar')->name = $request->name_ar;
        $setting->translateOrNew('en')->name = $request->name_en;
        $setting->translateOrNew('ar')->address = $request->address_ar;
        $setting->translateOrNew('en')->address = $request->address_en;
        $setting->translateOrNew('ar')->description = $request->description_ar;
        $setting->translateOrNew('en')->description = $request->description_en;
        $setting->logo = $picturePath;
        $setting->save();

        session()->flash('success', __('messages.update'));
        return back();
    }





    public function whatsapp()
    {
        $whatsapp = Whatsapp::firstOrCreate([]);
        return view('admin.whatsapp.index', compact('whatsapp'));
    }


    public function whatsapp_update(Request $request)
    {
        $request->validate([

            'app_key'         => 'required|string|max:255',
            'auth_key'        => 'required|string|max:255',
            'domain'          => 'required|string|max:255',
            'code'          => 'required|string|max:255',

        ]);

        $whatsapp = Whatsapp::first();


        $whatsapp->app_key = $request->app_key;
        $whatsapp->auth_key = $request->auth_key;
        $whatsapp->domain = $request->domain;
        $whatsapp->code = $request->code;

        $whatsapp->save();

        session()->flash('success', __('messages.update'));
        return back();
    }

    public function updateStatus(Request $request)
    {
        $request->validate([
            'active' => 'required|boolean',
        ]);

        $whatsapp = Whatsapp::first(); // Retrieve the first WhatsApp record (or change if needed)

        $whatsapp->active = $request->active;
        $whatsapp->save();

        return response()->json(['success' => true]);
    }


    public function invotek()
    {
        $invotek = Invotek::first();
        return view('admin.settings.invotek', compact('invotek'));
    }

    public function invotek_update(Request $request)
    {
        $request->validate([
            'url' => 'required|string|max:255',
            'user_code' => 'required|string|max:255',
        ]);

        $invotek = Invotek::first();
        $invotek->url = $request->url;
        $invotek->user_code = $request->user_code;
        $invotek->active = $request->active;
        $invotek->save();
        session()->flash('success', __('translations.update'));
        return back();
    }
}
