<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\WhatsAppTemplate;
use Illuminate\Http\Request;

class WhatsappController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:settings', ['only' => ['index']]);
    }

    public function all()
    {
        return view('admin.setting-management');
    }

    public function index()
    {
        return view('admin.whatsapp.index');
    }


    public function home()
    {
        // Get all WhatsApp templates
        $templates = WhatsAppTemplate::all();
        return view('admin.whatsappTemplate.index', compact('templates'));
    }

    public function show($id)
    {
        // Get the template by id
        $template = WhatsAppTemplate::findOrFail($id);

        // List of variables available in the template
        $variables = ['{name}', '{examination_number}', '{date}', '{type}'];

        return view('admin.whatsappTemplate.show', compact('template', 'variables'));
    }

    public function update(Request $request, $id)
    {
        
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'code' => 'required|string|max:255',
            'message' => 'required|string',
                 'active' => 'required|boolean',
        ]);

        $template = WhatsAppTemplate::findOrFail($id);
        $template->update($validated);

        return redirect()->back()->with('success', 'Template updated successfully!');
    }


    public function cron()
    {
        // Get server information
        $cronCommand = '* * * * * php ' . base_path('artisan') . ' schedule:run >> /dev/null 2>&1';

        return view('admin.cron.cron', compact('cronCommand'));
    }

public function updateStatus(Request $request, $id)
{
    return $request ; 
    // Validate the request to ensure 'active' is a required boolean
    $request->validate([
        'active' => 'required|boolean',
    ]);

    // Retrieve the WhatsAppTemplate by ID
    $whatsapp = WhatsAppTemplate::find($id);

    // If the template is not found, return a 404 response
    if (!$whatsapp) {
        return response()->json(['success' => false, 'message' => 'WhatsApp template not found'], 404);
    }

    // Update the 'active' status and save the changes
    $whatsapp->active = $request->active;
    $whatsapp->save();

    // Return a success response
    return response()->json(['success' => true]);
}


 
}
