<?php

namespace App\Http\Controllers;

use App\Models\Articles;
use App\Models\Compositions;
use App\Models\Courses;
use App\Models\LeaderLife;
use App\Models\profHistory;
use App\Models\programStages;
use App\Models\publications;
use App\Models\scientificCertificates;
use App\Models\Service;
use App\Models\skills;
use App\Models\summary;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class FrontendController extends Controller
{
    public function articles() {
        $locale = app()->getLocale();
        $title  = __('messages.researches');
        $articles = Articles::all();
        $publications = publications::all();
        return view('articles', compact('articles', 'publications', 'title', 'locale'));
    }

    public function articleDetails($article_id) {
        $locale = app()->getLocale();
        $articles = Articles::all();
        $articleDetail = Articles::findOrFail($article_id);
        $publications = Publications::all();
        $title = __('messages.researches') . ' | ' . ($articleDetail->translate($locale)->name ?? 'Default Title');
        return view('articleDetails', compact('articles', 'articleDetail', 'publications', 'title', 'locale'));
    }

    public function shortCV() {
        $locale = app()->getLocale();
        $articles = Articles::all();
        $shortCV = summary::first();
        $skills = skills::all();
        $publications = publications::all();
        $title = __('messages.cv') . '|' . __('messages.short-cv');
        return view('shortCV', compact('articles', 'shortCV', 'skills', 'publications', 'title', 'locale'));
    }

    public function totalCV() {
        $locale = app()->getLocale();
        $articles = Articles::all();
        $shortCV = summary::first();
        $skills = skills::all();
        $profHistory = profHistory::orderByTranslation('to_date', 'desc')->get();
        $certificates = scientificCertificates::orderByTranslation('to_date', 'desc')->get();
        $compositions = Compositions::orderByTranslation('to_date', 'desc')->get();
        $services = Service::with('subServices')->get();
        $publications = publications::all();
        $title = __('messages.cv') . '|' . __('messages.total-cv');
        return view('totalCV', compact('articles', 'shortCV', 'skills', 'profHistory', 'certificates', 'compositions', 'services', 'publications', 'title', 'locale'));
    }

    public function aboutLeader() {
        $locale = app()->getLocale();
        $articles = Articles::all();
        $shortCV = summary::first();
        $skills = skills::all();
        $profHistory = profHistory::all();
        $certificates = scientificCertificates::all();
        $compositions = Compositions::all();
        $leaderLife = LeaderLife::first();
        $publications = publications::all();
        $title = __('messages.aboutLeader');
        return view('aboutLeader', compact('articles', 'shortCV', 'skills', 'profHistory', 'certificates', 'compositions', 'leaderLife', 'publications', 'title', 'locale'));
    }

    public function detailsLeader() {
        $locale = app()->getLocale();
        $articles = Articles::all();
        $shortCV = summary::first();
        $skills = skills::all();
        $profHistory = profHistory::all();
        $certificates = scientificCertificates::all();
        $compositions = Compositions::all();
        $leaderLife = LeaderLife::first();
        $publications = publications::all();
        $title = __('messages.detailsLeader');
        return view('detailsLeader', compact('articles', 'shortCV', 'skills', 'profHistory', 'certificates', 'compositions', 'leaderLife', 'publications', 'title', 'locale'));
    }

    public function stagesLeader() {
        $locale = app()->getLocale();
        $articles = Articles::all();
        $shortCV = summary::first();
        $skills = skills::all();
        $profHistory = profHistory::all();
        $certificates = scientificCertificates::all();
        $compositions = Compositions::all();
        $leaderLife = LeaderLife::first();
        $programStages = programStages::all();
        $publications = publications::all();
        $title = __('messages.stagesLeader');

        return view(
            'stagesLeader ',
            compact(
                'articles',
                'shortCV',
                'skills',
                'profHistory',
                'certificates',
                'compositions',
                'leaderLife',
                'programStages',
                'publications',
                'title',
                'locale'
            )
        );
    }

    public function courses() {
        $locale = app()->getLocale();
        $articles = Articles::all();
        $shortCV = summary::first();
        $skills = skills::all();
        $profHistory = profHistory::all();
        $certificates = scientificCertificates::all();
        $compositions = Compositions::all();
        $leaderLife = LeaderLife::first();
        $programStages = programStages::all();
        $courses = Courses::all();
        $publications = publications::all();
        $title = __('messages.coursesAndProjects');

        return view(
            'courses ',
            compact(
                'articles',
                'shortCV',
                'skills',
                'profHistory',
                'certificates',
                'compositions',
                'leaderLife',
                'programStages',
                'courses',
                'publications',
                'title',
                'locale'
            )
        );
    }

    public function courseDetails($course_id) {
        $locale = app()->getLocale();
        $articles = Articles::all();
        $shortCV = summary::first();
        $skills = skills::all();
        $profHistory = profHistory::all();
        $certificates = scientificCertificates::all();
        $compositions = Compositions::all();
        $leaderLife = LeaderLife::first();
        $programStages = programStages::all();
        $courses = Courses::all();
        $courseDetails = Courses::where('id', $course_id)->first();
        $publications = publications::all();
        $title = __('messages.coursesAndProjects');

        return view(
            'courseDetails ',
            compact(
                'articles',
                'shortCV',
                'skills',
                'profHistory',
                'certificates',
                'compositions',
                'leaderLife',
                'programStages',
                'courses',
                'courseDetails',
                'publications',
                'title',
                'locale'
            )
        );
    }

    public function consultations($type) {
        $locale = app()->getLocale();
        $articles = Articles::all();
        $shortCV = summary::first();
        $skills = skills::all();
        $profHistory = profHistory::all();
        $certificates = scientificCertificates::all();
        $compositions = Compositions::all();
        $leaderLife = LeaderLife::first();
        $programStages = programStages::all();
        $courses = Courses::all();
        $publications = publications::all();
        $title = __('messages.consultations') . '|' . (($type == 'personal') ? __('messages.personal') : (($type == 'family') ? __('messages.family') : __('messages.company')));

        return view(
            'consultations ',
            compact(
                'articles',
                'shortCV',
                'skills',
                'profHistory',
                'certificates',
                'compositions',
                'leaderLife',
                'programStages',
                'courses',
                'type',
                'publications',
                'title',
                'locale'
            )
        );
    }

    public function contactUs() {
        $locale = app()->getLocale();
        $articles = Articles::all();
        $shortCV = summary::first();
        $skills = skills::all();
        $profHistory = profHistory::all();
        $certificates = scientificCertificates::all();
        $compositions = Compositions::all();
        $leaderLife = LeaderLife::first();
        $programStages = programStages::all();
        $courses = Courses::all();
        $publications = publications::all();
        $title = __('messages.contactUs');
        
        return view(
            'contactUS ',
            compact(
                'articles',
                'shortCV',
                'skills',
                'profHistory',
                'certificates',
                'compositions',
                'leaderLife',
                'programStages',
                'courses',
                'publications',
                'title',
                'locale'
            )
        );
    }
    
    public function publications($publication_id) {
        $locale = app()->getLocale();
        $articles = Articles::all();
        $shortCV = summary::first();
        $skills = skills::all();
        $profHistory = profHistory::all();
        $certificates = scientificCertificates::all();
        $compositions = Compositions::all();
        $leaderLife = LeaderLife::first();
        $programStages = programStages::all();
        $courses = Courses::all();
        $publications = publications::all();
        $getPublication = publications::where('id', $publication_id)->first();

        $title = __('messages.publications');
        return view(
            'getPublications ',
            compact(
                'articles',
                'shortCV',
                'skills',
                'profHistory',
                'certificates',
                'compositions',
                'leaderLife',
                'programStages',
                'courses',
                'publications',
                'getPublication',
                'title',
                'locale'
            )
        );
    }

    public function requestConsultations(Request $request) {
        $request->validate([
            'phone' => 'required|string|regex:/^96[0-9]{10}$/',
            'appName' => 'required|string',
            'country' => 'required|string'
        ], [
            'phone.required' => 'The phone number is required.',
            'phone.regex' => 'The phone number must start with 96 followed by 10 digits.',
        ]);
        try {
            $message1 = "Hello  {$request->appName}!  We have received your consultation request and will contact you as soon as possible.";
            $message2 = "Hello {$request->appName} from {$request->country} Submit a consultation request {$request->type} phone contact is : {$request->phone}";

            // Create the WhatsApp URL
            $whatsappUrl = "https://wa.me/{$request->phone}?text=" . urlencode($message1);
            $whatsappUrl = "https://wa.me/963993370415?text=" . urlencode($message2);

            $title = __('messages.consultationsForm');
            return redirect()->route('front.consultations', ['type' => $request->type, 'title' => $title])->with('نجح', 'تم إرسال الاستمارة بنجاح سيتم التواصل معكم بأقرب وقت ممكن :)');
        } catch (\Exception $e) {
            Log::info($e);
            DB::rollback();
            // Toastr::error('fail, Add new record  :)', 'Error');
            return redirect()->back();
        }
    }
}