<?php

namespace App\Http\Controllers;

use App\Models\Articles;
use App\Models\CompanyInfo;
use App\Models\ContactUs;
use App\Models\Courses;
use App\Models\Gallery;
use App\Models\Opinions;
use App\Models\Product;
use App\Models\publications;
use App\Models\Summary;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use App\Models\Theme;


class HomeController extends Controller
{
    public function index(Request $request) {
        $locale = app()->getLocale();
        $title = __('messages.home');
        $products = Product::all();
        $contactUs = ContactUs::all();
        $companyInfo = CompanyInfo::latest()->limit(1)->first();
        $services = [];
        $galleries = Gallery::all();
        $shortSV = Summary::first();
        $courses = Courses::all();
        $articles = Articles::all();
        $publications = publications ::all();
        $opinions = Opinions::all();

        return view('index', compact('products','contactUs','companyInfo','services','galleries','shortSV','courses','articles','publications','title','opinions','locale'));
    }

    public function setLocale(Request $request) {
        $locale = $request->input('locale');

        if(in_array($locale, ['en', 'ar'])) {
            Session::put('locale', $locale);
            App::setLocale($locale);
        }

        return redirect()->back();
    }
}
