<?php

namespace App\Http\Controllers;

use App\Services\WhatsAppService;
use Illuminate\Http\Request;

class WhatsAppController extends Controller
{
    protected $whatsAppService;

    public function __construct(WhatsAppService $whatsAppService)
    {
        $this->whatsAppService = $whatsAppService;
    }


    
    public function sendMessage(Request $request)
    {
        $request->validate([
            'template_code' => 'required|string',
            'to' => 'required|string',
            'variables' => 'required|array',
        ]);

        try {
            $response = $this->whatsAppService->sendTemplateMessage(
                $request->template_code,
                $request->to,
                $request->variables
            );

            return response()->json(['success' => true, 'response' => $response]);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'error' => $e->getMessage()], 500);
        }
    }
}
