<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Client extends Model
{
    use HasFactory;

    protected $table = 'clients';

    protected $fillable = [
        'first_name',
        'last_name',
        'age',
        'address',
        'phone',
        'city_id',
        'region_id',
        'country_code',
        'full_phone_number',
        'gender',
        'age'
    ];

    // Relationship with City
    public function city()
    {
        return $this->belongsTo(City::class);
    }

    // Relationship with Region
    public function region()
    {
        return $this->belongsTo(Region::class);
    }

    // Relationship with Examination
    public function examinations()
    {
        return $this->hasMany(Examination::class);
    }

    // Relationship with Invoice
    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }
}
