<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use PHPUnit\Framework\Constraint\Operator;

class Examination extends Model
{
    use HasFactory;

    protected $table = 'examinations';

    protected $fillable = [
        'code',
        'file',
        'notes',
        'type',
        'category',
        'client_id',
        'examiner_id',
        'create_by',
        'update_by',
        'status',
        'make_from',
        'special',
        'group'
    ];

    // Relationship with Client
    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    // Relationship with Examination_detail
    public function details()
    {
        return $this->hasMany(Examination_detail::class);
    }

    // Relationship with User (Creator)
    public function userCreate()
    {
        return $this->belongsTo(User::class, 'create_by');
    }

    // Relationship with User (Updater)
    public function userUpdate()
    {
        return $this->belongsTo(User::class, 'update_by');
    }

    public function receptions()
    {
        return $this->hasMany(Reception::class);
    }

    public function operations()
    {
        return $this->hasMany(Operation::class);
    }

    public function deliveries()
    {
        return $this->hasMany(Delivery::class);
    }

    public function recieveds()
    {
        return $this->hasMany(Recieved::class);
    }

    public function examiner()
    {
        return $this->belongsTo(Examiner::class, 'examiner_id');
    }

    public function examinationDetails()
    {
        return $this->hasMany(Examination_detail::class);
    }
}
