<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Laratrust\Traits\HasRolesAndPermissions;

class Examiner extends Model
{
    use HasFactory, HasRolesAndPermissions;
    protected $table = 'examiners';

    protected $fillable = [
        'name',
        'email',
        'phone',
        'address',
        'age',
        'create_by',
        'update_by',
    ];


    public function examinations()
    {
        return $this->hasMany(Examination::class, 'examiner_id');
    }


}
