<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;

    protected $fillable = ['number', 'uuid', 'origin_number', 'original_uid', 'return_reason',  'total_price', 'status', 'payment_method_code', 'client_id', 'sent_to_invotek', 'einv_qr', 'issue_date'];

    public function details()
    {
        return $this->hasMany(InvoiceDetail::class);
    }

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    public function products()
    {
        return $this->hasMany(Product::class);
    }

}
