<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Region extends Model
{
    use HasFactory;

    protected $table = 'regions';

    protected $fillable = [
        'first_name',
        'city_id',
    ];



    // العلاقة مع المدينة
    public function city()
    {
        return $this->belongsTo(City::class);
    }

    // العلاقة مع العملاء
    public function clients()
    {
        return $this->hasMany(Client::class);
    }

}
