<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Room extends Model
{
    use HasFactory;
    protected $table = 'rooms';

    protected $fillable = [
        'name',
        'room_code',
        'group',
    ];

    public function users()
    {
        return $this->hasMany(User::class, 'room_code', 'room_code');
    }


    public function examinations()
    {
        return $this->hasManyThrough(
            Examination::class, // Final model
            User::class,        // Intermediate model
            'room_code',        // Foreign key in `users` table (refers to `rooms.room_code`)
            'create_by',        // Foreign key in `examinations` table (refers to `users.id`)
            'room_code',        // Local key in `rooms` table (refers to `rooms.room_code`)
            'id'                // Local key in `users` table (refers to `users.id`)
        );
    }


}
