<?php

namespace App\Providers;

use App\Models\Settings;
use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\DB;

class AppServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        //
    }

    public function boot(): void
    {
        if (!app()->runningInConsole()) {
            $setting = Settings::firstOr(function () {
                $setting = Settings::create([
                    'email'  => 'admin@gmail.com',
                    'phone1' => '065865799',
                    'phone2' => '065865799',
                ]);

                DB::table('settings_translations')->insert([
                    [
                        'settings_id' => $setting->id,
                        'name'        => 'شركة نجوم الابتكار',
                        'address'     => 'الأردن',
                        'description' => "تأسست شركة نجوم الابتكار عام 2025 في عمان لتقدم الأفضل في عالم البصريات:\n- فحص نظر مجاني\n- نظارات طبية وشمسية\n- عدسات طبية وملونة",
                        'locale'      => 'ar',
                    ],
                    [
                        'settings_id' => $setting->id,
                        'name'        => 'Star Innovation',
                        'address'     => 'Jordan',
                        'description' => "Founded in 2025 in Amman, Star Innovation offers the best in the world of optics:\n- Free vision test\n- Medical and sunglasses\n- Medical and colored lenses",
                        'locale'      => 'en',
                    ],
                ]);

                return $setting;
            });

            view()->share('setting', $setting);
        }

        Paginator::useBootstrap();
    }
}
