<?php

namespace App\Providers;

use App\Models\ThemeSettings;
use App\Services\ThemeService;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Config;

class ThemeServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Register the theme service singleton
        $this->app->singleton('theme', function ($app) {
            return new ThemeService();
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        if (!app()->runningInConsole()) {
        // Get theme settings from database (or use default if not exists)
        $themeSettings = ThemeSettings::first();

        if (!$themeSettings) {
            $themeSettings = new ThemeSettings();
            $themeSettings->sidebar_bg_color = '#1e1e2d';
            $themeSettings->sidebar_text_color = '#ffffff';
            $themeSettings->header_bg_color = '#ffffff';
            $themeSettings->header_text_color = '#3F4254';
            $themeSettings->primary_color = '#009ef7';
            $themeSettings->secondary_color = '#E4E6EF';
            $themeSettings->text_color = '#3F4254';
            $themeSettings->link_color = '#009ef7';
            $themeSettings->font_family = 'Tajawal, Arial, sans-serif';
            $themeSettings->base_font_size = '14px';
            $themeSettings->heading_font_size = '1.25rem';
            $themeSettings->menu_font_size = '1rem';
            $themeSettings->is_dark_mode = false;
        }

        // Share theme settings with all views
        View::share('theme', $themeSettings);

        // Add theme settings to configuration without overriding presets
        Config::set('theme.settings', $themeSettings->toArray());

            // Add CSS variables to all views
            $cssVariables = $this->app->make('theme')->cssVariables();
            View::share('themeCssVariables', $cssVariables);
        }
    }
}
