<?php

namespace App\Services;

use App\Models\Invotek;
use Illuminate\Support\Facades\Http;

class InvotekService
{
    protected $apiUrl;
    protected $apiUrlReturn;
    protected $userCode;

    public function __construct()
    {
        $invotekConfig = Invotek::first();

        if (!$invotekConfig) {
            throw new \Exception("Invotek configuration not found in the database.");
        }

        $this->apiUrl = "{$invotekConfig->url}/api/user/income";
        $this->apiUrlReturn = "{$invotekConfig->url}/api/user/income-credit";
        $this->userCode = $invotekConfig->user_code;
    }

    public function getIncome($invoice,$details,$client)
    {

        $data =  [
                'user_code' => $this->userCode,
                'invoice_no' => (string)$invoice->number,
                'issue_date' => $invoice->issue_date,
                'payment_method_code' => $invoice->payment_method_code,
                'description' => $invoice->description ?? '',
                'customer_name' => $invoice->client->first_name . ' ' . $invoice->client->last_name,
                'customer_id' => (string)$invoice->client->id,
                'customer_street_name' => $invoice->client->street_name ?? '',
                'customer_building_number' => $invoice->client->customer_building_number ?? '',
                'customer_plot_identification' => $invoice->client->customer_plot_identification ?? '',
                'customer_city_subdivision_name' => $invoice->client->customer_city_subdivision_name ?? '',
                'customer_city_name' => $invoice->client->customer_city_name ?? '',
                'customer_postal_code' => $invoice->client->customer_postal_code ?? '',
                'customer_country_subentity_code' => $invoice->client->customer_country_subentity_code ?? '',
                'customer_phone' => $invoice->client->phone ?? '',
                'items' => $details,
                'tax_exclusive_amount' => $invoice->total_price,
                'tax_inclusive_amount' => $invoice->total_price,
                'allowance_total_amount' => $invoice->discount ?? 0,
                'payable_amount' => $invoice->total_price - $invoice->discount,
        ];
        // return $data;
        $response = Http::post($this->apiUrl, $data);
        return $response;
    }
    public function getReturnInvoice($invoice,$details,$client,$returnInvoice)
    {
        $data = [
                'user_code' => $this->userCode,
                'invoice_no' => $returnInvoice->number,
                'issue_date' => $returnInvoice->issue_date,
                'payment_method_code' => $returnInvoice->payment_method_code,
                'description' => $returnInvoice->description ?? '',
                'customer_name' => $returnInvoice->client->first_name . ' ' . $returnInvoice->client->last_name,
                'customer_id' => (string)$returnInvoice->client->id,
                'customer_street_name' => $returnInvoice->client->street_name ?? '',
                'customer_building_number' => $returnInvoice->client->customer_building_number ?? '',
                'customer_plot_identification' => $returnInvoice->client->customer_plot_identification ?? '',
                'customer_city_subdivision_name' => $returnInvoice->client->customer_city_subdivision_name ?? '',
                'customer_city_name' => $returnInvoice->client->customer_city_name ?? '',
                'customer_postal_code' => $returnInvoice->client->customer_postal_code ?? '',
                'customer_country_subentity_code' => $returnInvoice->client->customer_country_subentity_code ?? '',
                'customer_phone' => $returnInvoice->client->phone ?? '',
                'items' => $details,
                'tax_exclusive_amount' => $returnInvoice->total_price,
                'tax_inclusive_amount' => $returnInvoice->total_price,
                'allowance_total_amount' => $returnInvoice->discount ?? 0,
                'payable_amount' => $returnInvoice->total_price - $returnInvoice->discount,


                "original_invoice_no" => (string)$invoice->number,
                "original_total_amount" => $invoice->total_price,
                "original_uid" => (string)$invoice->uuid,
                "description_retuen_reason" => $invoice->return_reason ?? 'test',
        ];
        // return $data;
        $response = Http::post($this->apiUrlReturn, $data);

        return $response;
    }
}
