<?php

use App\Services\ThemeService;
use Illuminate\Support\Facades\App;

if (!function_exists('theme')) {
    /**
     * Get theme service instance or specific theme setting
     *
     * @param string|null $key
     * @param mixed $default
     * @return mixed
     */
    function theme($key = null, $default = null)
    {
        $themeService = App::make('theme');

        if (is_null($key)) {
            return $themeService;
        }

        return $themeService->get($key, $default);
    }
}

if (!function_exists('theme_style')) {
    /**
     * Get inline style for an element
     *
     * @param string $element
     * @return string
     */
    function theme_style($element)
    {
        return App::make('theme')->inlineStyle($element);
    }
}

if (!function_exists('is_dark_mode')) {
    /**
     * Check if dark mode is enabled
     *
     * @return bool
     */
    function is_dark_mode()
    {
        return App::make('theme')->isDarkMode();
    }
}

if (!function_exists('theme_css_variables')) {
    /**
     * Get theme CSS variables
     *
     * @return string
     */
    function theme_css_variables()
    {
        return App::make('theme')->cssVariables();
    }
}

if (!function_exists('theme_presets')) {
    /**
     * Get theme presets
     *
     * @return array
     */
    function theme_presets()
    {
        return App::make('theme')->getPresets();
    }
}

if (!function_exists('theme_preset')) {
    /**
     * Get specific theme preset
     *
     * @param string $key
     * @return array|null
     */
    function theme_preset($key)
    {
        return App::make('theme')->getPreset($key);
    }
}
