<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Default Theme Settings
    |--------------------------------------------------------------------------
    |
    | These are the default theme settings that will be used if no theme settings
    | are found in the database.
    |
    */
    'defaults' => [
        'sidebar_bg_color' => '#1e1e2d',
        'sidebar_text_color' => '#ffffff',
        'header_bg_color' => '#ffffff',
        'header_text_color' => '#3F4254',
        'primary_color' => '#009ef7',
        'secondary_color' => '#E4E6EF',
        'text_color' => '#3F4254',
        'link_color' => '#009ef7',
        'font_family' => 'Tajawal, Arial, sans-serif',
        'base_font_size' => '14px',
        'heading_font_size' => '1.25rem',
        'menu_font_size' => '1rem',
        'is_dark_mode' => false,
    ],

    /*
    |--------------------------------------------------------------------------
    | Available Theme Presets
    |--------------------------------------------------------------------------
    |
    | These are the predefined theme presets that can be selected by the user.
    |
    */
    'presets' => [
        'default' => [
            'name' => 'الافتراضي',
            'sidebar_bg_color' => '#298DE9',
            'sidebar_text_color' => '#ffffff',
            'header_bg_color' => '#298DE9',
            'header_text_color' => '#ffffff',
            'primary_color' => '#009ef7',
            'secondary_color' => '#E4E6EF',
            'text_color' => '#3F4254',
            'link_color' => '#009ef7',
            'font_family' => 'Tajawal, Arial, sans-serif',
            'base_font_size' => '14px',
            'heading_font_size' => '1.25rem',
            'menu_font_size' => '1rem',
            'is_dark_mode' => false,
        ],


        'warm_gold' => [
            'name' => 'الذهبي الفاخر',
            'sidebar_bg_color' => '#000',
            'sidebar_text_color' => '#ffe03b',
            'header_bg_color' => '#000',
            'header_text_color' => '#ffe03b',
            'primary_color' => '#ffe03b',
            'secondary_color' => '#fff3e0',
            'text_color' => '#424242',
            'link_color' => '#ffe03b',
            'font_family' => 'Tajawal, Arial, sans-serif',
            'base_font_size' => '14px',
            'heading_font_size' => '1.25rem',
            'menu_font_size' => '1rem',
            'is_dark_mode' => false,
        ],
    ],
];
