<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->id();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('phone');
            $table->enum('gender', ['man', 'woman'])->nullable();
            $table->string('age')->nullable();
            $table->string('address')->nullable();
            $table->unsignedBigInteger('city_id')->nullable(); // Define city_id column
            $table->unsignedBigInteger('region_id')->nullable(); // Define region_id column
            $table->string('country_code', 5)->nullable();
            $table->string('full_phone_number', 255)->nullable();
            $table->timestamps();
            // Add indexes after defining the columns
            $table->index('city_id');
            $table->index('region_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('clients');
    }
};
