<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('examinations', function (Blueprint $table) {
            $table->id();
            $table->string('code');
            $table->string('file')->nullable();
            $table->string('notes')->nullable();
            $table->enum('type', ['نظارات', 'عدسات']);
            $table->enum('make_from', ['examinations', 'receptions']);
            $table->enum('status', ['في انتظار التاكيد', 'ارسال الي المشغل', 'تم التجهيز', 'تم الاستلام', 'الغاء']);
            $table->enum('special', ['عادي', 'مميز', 'مستعجل', 'تحضير', 'توصيل']);
            $table->enum('category', ['a', 'b', 'c', 'd'])->nullable();
            $table->string('room_code')->nullable();
            $table->index('room_code');
            $table->index('client_id');
            $table->unsignedBigInteger('client_id')->nullable();
            $table->unsignedBigInteger('examiner_id'); // المفتاح الأجنبي
            $table->unsignedBigInteger('create_by')->nullable();
            $table->unsignedBigInteger('update_by')->nullable();
            $table->string('group')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('examinations');
    }
};
