<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('examination_details', function (Blueprint $table) {
            $table->id();
            $table->string('sph')->nullable();
            $table->string('cyl')->nullable();
            $table->string('axis')->nullable();
            $table->string('lpd')->nullable();
            $table->string('add')->nullable();
            $table->enum('type', ['R', 'L'])->nullable();
            $table->unsignedBigInteger('examination_id')->nullable();
            $table->foreign('examination_id')->references('id')->on('examinations')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('examination_details');
    }
};
