<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('receptions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('examination_id');  // لربط الفحص
            $table->enum('status', ['تم التأكيد', ' الغاء '])->default('تم التأكيد'); // حالة الاستلام
            $table->timestamps();

            // إنشاء علاقة بين الفحوصات و استقبال الفحص
            $table->foreign('examination_id')->references('id')->on('examinations')->onDelete('cascade');
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('receptions');
    }
};
