<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('data', function (Blueprint $table) {
            $table->id();
            $table->string('data_rt');
            $table->string('data_lt');
            $table->string('lpd_rt');
            $table->string('lpd_lt');
            $table->string('add_rt');
            $table->string('add_lt');
            $table->unsignedBigInteger('room_code')->nullable();
            $table->timestamps();
            $table->index('room_code');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('data');
    }
};
