
<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWhatsappTemplatesTable extends Migration
{
    public function up()
    {
        Schema::create('whatsapp_templates', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique(); // Name of the template
            $table->boolean('active')->default(true); // Whether the template is active
            $table->string('code')->unique(); // Code to identify the template
            $table->text('message'); // The template message
            $table->json('age_range')->nullable(); // Age range array (e.g., [20, 40])
            $table->json('months')->nullable(); // Months array (e.g., [6, 12])
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('whatsapp_templates');
    }
}
