<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('number')->unique();
            $table->uuid('uuid')->unique()->nullable();
            $table->string('origin_number')->unique()->nullable();
            $table->string('original_uid')->unique()->nullable();
            $table->string('return_reason')->nullable();
            $table->string('total_price');
            $table->string('status');
            $table->string('payment_method_code');
            $table->string('client_id');
            $table->boolean('sent_to_invotek')->default(0);
            $table->text('einv_qr')->nullable();
            $table->date('issue_date');
            $table->text('description')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
