<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoteks', function (Blueprint $table) {
            $table->id();
            $table->string('url');
            $table->boolean('active')->default(1);
            $table->string('user_code');
            $table->enum('type', ['income', 'general'])->default('income');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoteks');
    }
};
