<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('theme_settings', function (Blueprint $table) {
            $table->id();
            $table->string('sidebar_bg_color')->default('#1e1e2d');
            $table->string('header_bg_color')->default('#ffffff');
            $table->string('primary_color')->default('#009ef7');
            $table->string('secondary_color')->default('#E4E6EF');
            $table->string('font_family')->default('Poppins, Arial, sans-serif');
            $table->string('base_font_size')->default('13px');
            $table->string('heading_font_size')->default('1.25rem');
            $table->string('menu_font_size')->default('1rem');
            $table->string('text_color')->default('#3F4254');
            $table->string('link_color')->default('#009ef7');
            $table->string('sidebar_text_color')->default('#ffffff');
            $table->string('header_text_color')->default('#3F4254');
            $table->boolean('is_dark_mode')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('theme_settings');
    }
};
