<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Client;
use App\Models\City; // Assuming you have a City model
use App\Models\Region; // Assuming you have a Region model
use Carbon\Carbon;

class ClientSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Sample client data
        $clients = [
            [
                'first_name' => 'محمد',
                'last_name' => 'عبد الرحمن',
                'phone' => '1095193236',
                'address' => '123 Street, Cairo, Egypt',
                'city_id' => 1, // Assuming 1 is the ID of Cairo
                'region_id' => 1, // Assuming 1 is the ID of a region in Cairo
                'age' => 20,
            ],
            [
                'first_name' => 'محمود',
                'last_name' => 'احمد',
                'phone' => '01118759692',
                'address' => '456 Street, Giza, Egypt',
                'city_id' => 2, // Assuming 2 is the ID of Giza
                'region_id' => 2, // Assuming 2 is the ID of a region in Giza
                'age' => 20,
            ],
            // Add more clients here if needed
        ];

        // Insert sample data into the clients table
        foreach ($clients as $client) {
            Client::create([
                'first_name' => $client['first_name'],
                'last_name' => $client['last_name'],
                'phone' => $client['phone'],
                'address' => $client['address'],
                'city_id' => $client['city_id'],
                'region_id' => $client['region_id'],
                'age' => $client['age'],
            ]);
        }
    }
}
