<?php

namespace Database\Seeders;

use App\Models\Country;
use Illuminate\Database\Seeder;

class CountrySeeder extends Seeder
{
    public function run()
    {
        $countries = [
            ['name_ar' => 'السعودية', 'code' => 'SA', 'phone' => '+966'],
            ['name_ar' => 'مصر', 'code' => 'EG', 'phone' => '+20'],
            ['name_ar' => 'الإمارات', 'code' => 'AE', 'phone' => '+971'],
            ['name_ar' => 'الكويت', 'code' => 'KW', 'phone' => '+965'],
            ['name_ar' => 'قطر', 'code' => 'QA', 'phone' => '+974'],
            ['name_ar' => 'البحرين', 'code' => 'BH', 'phone' => '+973'],
            ['name_ar' => 'عمان', 'code' => 'OM', 'phone' => '+968'],
            ['name_ar' => 'اليمن', 'code' => 'YE', 'phone' => '+967'],
            ['name_ar' => 'الأردن', 'code' => 'JO', 'phone' => '+962'],
            ['name_ar' => 'العراق', 'code' => 'IQ', 'phone' => '+964'],
            ['name_ar' => 'سوريا', 'code' => 'SY', 'phone' => '+963'],
            ['name_ar' => 'لبنان', 'code' => 'LB', 'phone' => '+961'],
            ['name_ar' => 'فلسطين', 'code' => 'PS', 'phone' => '+970'],
            ['name_ar' => 'الجزائر', 'code' => 'DZ', 'phone' => '+213'],
            ['name_ar' => 'المغرب', 'code' => 'MA', 'phone' => '+212'],
            ['name_ar' => 'تونس', 'code' => 'TN', 'phone' => '+216'],
            ['name_ar' => 'ليبيا', 'code' => 'LY', 'phone' => '+218'],
            ['name_ar' => 'السودان', 'code' => 'SD', 'phone' => '+249'],
            ['name_ar' => 'موريتانيا', 'code' => 'MR', 'phone' => '+222'],
        ];

        foreach ($countries as $country) {
            Country::create($country);
        }
    }
}
