<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Examiner;

class ExaminerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Sample examiner data
        $examiners = [
            [
                'name' => 'Dr. Yasser Khaled',
                'email' => 'yasser.khaled@example.com',
                'phone' => '01011223344',
                'address' => '101 Elm Street, Cairo, Egypt',
                'age' => 42,
            ],
            [
                'name' => 'Dr. Layla Ramadan',
                'email' => 'layla.ramadan@example.com',
                'phone' => '01233445566',
                'address' => '202 Maple Road, Giza, Egypt',
                'age' => 35,
            ],
            [
                'name' => 'Dr. Samir Fawzy',
                'email' => 'samir.fawzy@example.com',
                'phone' => '01055667788',
                'address' => '303 Oak Avenue, Alexandria, Egypt',
                'age' => 48,
            ],
            [
                'name' => 'Dr. Rania Hossam',
                'email' => 'rania.hossam@example.com',
                'phone' => '01166778899',
                'address' => '404 Pine Street, Tanta, Egypt',
                'age' => 38,
            ],
            [
                'name' => 'Dr. Khaled Mostafa',
                'email' => 'khaled.mostafa@example.com',
                'phone' => '01578889900',
                'address' => '505 Birch Lane, Mansoura, Egypt',
                'age' => 52,
            ],
        ];

        // Insert sample data into the examiners table
        foreach ($examiners as $examiner) {
            Examiner::create([
                'name' => $examiner['name'],
                'email' => $examiner['email'],
                'phone' => $examiner['phone'],
                'address' => $examiner['address'],
                'age' => $examiner['age'],
            ]);
        }
    }
}
