<?php

namespace Database\Seeders;

use App\Models\ExpenseCategory;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ExpenseCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            ['name' => 'الإيجار والسكن', 'description' => 'تشمل الإيجار، الرهن العقاري، والصيانة المنزلية'],
            ['name' => 'المرافق', 'description' => 'الكهرباء، الماء، الغاز، الإنترنت، الهاتف'],
            ['name' => 'الطعام', 'description' => 'البقالة، المطاعم، الطلبات الخارجية'],
            ['name' => 'النقل', 'description' => 'الوقود، صيانة السيارة، النقل العام، التاكسي'],
            ['name' => 'الصحة', 'description' => 'التأمين الصحي، الأدوية، زيارات الطبيب، العلاجات الطبية'],
            ['name' => 'التعليم', 'description' => 'الرسوم الدراسية، الكتب، اللوازم المدرسية، الدورات التدريبية'],
            ['name' => 'الملابس', 'description' => 'الملابس، الأحذية، الإكسسوارات'],
            ['name' => 'الترفيه', 'description' => 'السينما، الرياضة، السفر، الهوايات'],
            ['name' => 'الديون', 'description' => 'سداد القروض، بطاقات الائتمان، الديون الشخصية'],
            ['name' => 'التوفير والاستثمار', 'description' => 'حسابات التوفير، الاستثمارات، صناديق التقاعد'],
            ['name' => 'الهدايا والتبرعات', 'description' => 'الهدايا، التبرعات الخيرية، المناسبات الاجتماعية'],
            ['name' => 'الضرائب', 'description' => 'ضريبة الدخل، ضريبة الممتلكات، الضرائب الأخرى'],
            ['name' => 'التأمين', 'description' => 'تأمين السيارة، تأمين المنزل، تأمين الحياة'],
            ['name' => 'الاشتراكات', 'description' => 'اشتراكات الخدمات الرقمية، الصحف، المجلات، النوادي'],
            ['name' => 'العناية الشخصية', 'description' => 'مستحضرات التجميل، الحلاقة، الصالونات'],
            ['name' => 'الأجهزة والإلكترونيات', 'description' => 'الهواتف، الكمبيوترات، الأجهزة المنزلية'],
            ['name' => 'مصاريف الأطفال', 'description' => 'الحضانة، الألعاب، مستلزمات الأطفال'],
            ['name' => 'مصاريف الحيوانات الأليفة', 'description' => 'الطعام، الرعاية البيطرية، مستلزمات الحيوانات'],
            ['name' => 'الاتصالات', 'description' => 'فواتير الهاتف المحمول، الإنترنت، خدمات الاتصالات'],
            ['name' => 'أخرى', 'description' => 'مصاريف متنوعة غير مصنفة في الفئات السابقة'],
        ];

        foreach ($categories as $category) {
            ExpenseCategory::create($category);
        }
    }
}
