<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Seeder;

class PermissionSeeder extends Seeder
{
    public function run(): void
    {


        // dashboard permissions
        Permission::create([
            'name'         => 'dashboard-view',
            'display_name' => 'عرض لوحة التحكم',
        ]);


        // roles permissions
        Permission::create([
            'name'         => 'roles-list',
            'display_name' => 'عرض مستوى الصلاحيات',
        ]);
        Permission::create([
            'name'         => 'roles-create',
            'display_name' => 'اضافة مستوى الصلاحيات',
        ]);
        Permission::create([
            'name'         => 'roles-edit',
            'display_name' => 'تعديل مستوى الصلاحيات',
        ]);
        Permission::create([
            'name'         => 'roles-delete',
            'display_name' => 'حذف مستوى الصلاحيات',
        ]);




        // users permissions
        Permission::create([
            'name'         => 'users-list',
            'display_name' => 'عرض المستخدمين',
        ]);
        Permission::create([
            'name'         => 'users-create',
            'display_name' => 'اضافة المستخدمين',
        ]);
        Permission::create([
            'name'         => 'users-edit',
            'display_name' => 'تعديل المستخدمين',
        ]);
        Permission::create([
            'name'         => 'users-delete',
            'display_name' => 'حذف المستخدمين',
        ]);



        // clients permissions
        Permission::create([
            'name'         => 'clients-list',
            'display_name' => 'عرض العملاء',
        ]);
        Permission::create([
            'name'         => 'clients-show',
            'display_name' => 'عرض العملاء',
        ]);
        Permission::create([
            'name'         => 'clients-create',
            'display_name' => 'اضافة العملاء',
        ]);
        Permission::create([
            'name'         => 'clients-edit',
            'display_name' => 'تعديل العملاء',
        ]);
        Permission::create([
            'name'         => 'clients-delete',
            'display_name' => 'حذف العملاء',
        ]);



        // reports permissions

        Permission::create([
            'name'         => 'reports-examinations',
            'display_name' => 'عرض  تقرير الفحوصات',
        ]);

        Permission::create([
            'name'         => 'reports-clients',
            'display_name' => 'عرض  تقرير العملاء',
        ]);










        // receptions permissions
        Permission::create([
            'name'         => 'receptions-list',
            'display_name' => 'عرض  قائمة الاستقبال',
        ]);
        Permission::create([
            'name'         => 'receptions-create',
            'display_name' => 'اضافة فحص سريع',
        ]);
        Permission::create([
            'name'         => 'receptions-edit',
            'display_name' => 'تعديل فحص سريع',
        ]);
        Permission::create([
            'name'         => 'receptions-show',
            'display_name' => 'عرض  فحوصات الاستقبال',
        ]);
        Permission::create([
            'name'         => 'receptions-delete',
            'display_name' => 'حذف فحوصات ',
        ]);
















        // settings permissions
        Permission::create([
            'name'         => 'settings',
            'display_name' => 'اعدادات النظام',
        ]);

        // settings permissions
        Permission::create([
            'name'         => 'whatsapp',
            'display_name' => 'اعدادات الواتساب',
        ]);


        // categories permissions
        Permission::create([
            'name'         => 'categories-list',
            'display_name' => 'عرض  قائمة الاصناف',
        ]);
        Permission::create([
            'name'         => 'categories-create',
            'display_name' => 'اضافة الاصناف',
        ]);
        Permission::create([
            'name'         => 'categories-edit',
            'display_name' => 'تعديل الاصناف',
        ]);
        Permission::create([
            'name'         => 'categories-delete',
            'display_name' => 'حذف الاصناف',
        ]);

        // products permissions
        Permission::create([
            'name'         => 'products-list',
            'display_name' => 'عرض  قائمة المنتجات',
        ]);
        Permission::create([
            'name'         => 'products-create',
            'display_name' => 'اضافة المنتجات',
        ]);
        Permission::create([
            'name'         => 'products-edit',
            'display_name' => 'تعديل المنتجات',
        ]);
        Permission::create([
            'name'         => 'products-delete',
            'display_name' => 'حذف المنتجات',
        ]);
        Permission::create([
            'name'         => 'products-show',
            'display_name' => 'عرض المنتجات',
        ]);

        // expense categories permissions
        Permission::create([
            'name'         => 'expense-categories-list',
            'display_name' => 'عرض فئات المصروفات',
        ]);
        Permission::create([
            'name'         => 'expense-categories-create',
            'display_name' => 'إضافة فئات المصروفات',
        ]);
        Permission::create([
            'name'         => 'expense-categories-edit',
            'display_name' => 'تعديل فئات المصروفات',
        ]);
        Permission::create([
            'name'         => 'expense-categories-delete',
            'display_name' => 'حذف فئات المصروفات',
        ]);

        // expenses permissions
        Permission::create([
            'name'         => 'expenses-list',
            'display_name' => 'عرض المصروفات',
        ]);
        Permission::create([
            'name'         => 'expenses-create',
            'display_name' => 'إضافة المصروفات',
        ]);
        Permission::create([
            'name'         => 'expenses-edit',
            'display_name' => 'تعديل المصروفات',
        ]);
        Permission::create([
            'name'         => 'expenses-show',
            'display_name' => 'عرض تفاصيل المصروفات',
        ]);
        Permission::create([
            'name'         => 'expenses-delete',
            'display_name' => 'حذف المصروفات',
        ]);

        // invoices permissions
        Permission::create([
            'name'         => 'invoices-list',
            'display_name' => 'عرض  قائمة الفواتير',
        ]);
        Permission::create([
            'name'         => 'invoices-create',
            'display_name' => 'اضافة الفواتير',
        ]);
        Permission::create([
            'name'         => 'invoices-edit',
            'display_name' => 'تعديل الفواتير',
        ]);
        Permission::create([
            'name'         => 'invoices-show',
            'display_name' => 'عرض الفواتير',
        ]);
        Permission::create([
            'name'         => 'invoices-delete',
            'display_name' => 'حذف الفواتير',
        ]);
        Permission::create([
            'name'         => 'invoices-return',
            'display_name' => 'ارجاع الفواتير',
        ]);

        // financial reports permissions
        Permission::create([
            'name'         => 'finance-reports',
            'display_name' => 'تقارير مالية',
        ]);
        Permission::create([
            'name'         => 'invoices-resend',
            'display_name' => 'ارسال الفواتير',
        ]);
    }
}
