<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\City;
use App\Models\Region;

class RegionsSeeder extends Seeder
{
    public function run(): void
    {
        $regions = [
          'عمان' => [
    'أم أذينة',
    'أم السماق',
    'الجبيهة',
    'الذراع الغربي',
    'الشميساني',
    'الصويفية',
    'المحطة',
    'الهاشمي الشمالي',
    'بيادر وادي السير',
    'جبل الأشرفية',
    'جبل التاج',
    'جبل الجوفة',
    'جبل الحسين',
    'جبل القصور',
    'جبل اللويبدة',
    'جبل المريخ',
    'جبل النزهة',
    'جبل النصر',
    'جبل النظيف',
    'جبل عمان',
    'حي الرابية',
    'حي الطفايلة',
    'حي المزارع',
    'حي غمدان',
    'حي نزال',
    'خلدا',
    'دابوق',
    'ضاحية النخيل',
    'ضاحية الياسمين',
    'طبربور',
    'عبدون',
    'عمان الشرقية',
    'عمان الغربية'
],
          'إربد' => [
    'إربد',
    'أبسر أبو علي',
    'أبو القين',
    'أبو اللوقس',
    'أبو زياد',
    'أبو سيدو',
    'أبو هابيل',
    'أرخيم',
    'أم الهوى',
    'أم قيس',
    'إبدر',
    'إرحابا',
    'إزمال',
    'إيدون',
    'اسكايين',
    'الأشرفية',
    'الإبراهيمية',
    'الباقورة',
    'البويضة',
    'الحصن',
    'الحمة الأردنية',
    'الخراج',
    'الخريبة',
    'الذنيبة',
    'الرحمة',
    'الرفيد',
    'الرقة',
    'الرهوة',
    'الزعترة',
    'الزوية',
    'السيلة',
    'الشجرة',
    'الشونة الشمالية',
    'الشيخ حسين',
    'الصريح',
    'الصوان',
    'الطرة',
    'الطيبة',
    'العدسية',
    'العشة',
    'القصفة',
    'الكورة',
    'المخيبة التحتا',
    'المزار الشمالي',
    'المزيريب',
    'المشارع',
    'المغير',
    'المنشية',
    'المنصورة',
    'النعيمة',
    'الوسية',
    'اليرموك',
    'البارحة',
    'برشتا',
    'بشرى',
    'بلدية السرو',
    'بيت إيدس',
    'بيت رأس',
    'بيت يافا',
    'تبنة',
    'تقبل',
    'ججين',
    'جحفية',
    'جديتا',
    'جفين',
    'جمحة',
    'جنين الصفا',
    'حاتم',
    'حبراص',
    'حبكا',
    'حرثا',
    'حريما',
    'حكما',
    'حوارة',
    'حور',
    'حوفا المزار',
    'حوفا الوسطية',
    'خربة الحاوي',
    'خرجا',
    'دوقره',
    'دير أبي سعيد',
    'دير السعنة',
    'دير يوسف',
    'زبدة الوسطية',
    'زحر',
    'زمال',
    'زوبيا',
    'سال',
    'سبيرة',
    'سحم',
    'سما الروسان',
    'سمر',
    'سموع',
    'سوم',
    'شطنا',
    'صما',
    'صمد',
    'صيدور',
    'طبقة فحل',
    'عالية',
    'عزريت',
    'عقربا',
    'علعال',
    'عمراوة',
    'عنبة',
    'فوعره',
    'قرية مرحبا',
    'قم',
    'قميم',
    'كتم',
    'كركمة',
    'كريمة',
    'كفر أبيل',
    'كفر أسد',
    'كفر الماء',
    'كفر جايز',
    'كفر راكب',
    'كفر رحتا',
    'كفر سوم',
    'كفر عان',
    'كفر عوان',
    'كفر كيفيا',
    'كفر يوبا',
    'ماجد',
    'مخربا',
    'مخيم الشهيد عزمي المفتي',
    'مرو',
    'ملكا',
    'مندح',
    'ناطفة',
    'هام',
    'وادي الريان',
    'وادي العرب',
    'وقاص',
    'يبلا'
],

'الزرقاء' => [
    'الزرقاء',
    'المنطقة الحرة',
    'حي الزواهرة',
    'حي ابن سينا',
    'حي الأميرة هيا',
    'حي الأمير محمد',
    'مدينة الشرق',
    'الزرقاء الجديدة',
    'ياجوز',
    'حي جبر',
    'حي معصوم',
    'حي رمزي',
    'حي الحسين',
    'مدينة المجد',
    'حي الجندي',
    'حي الفلاح',
    'حي الجنينة',
    'حي الأمير عبد الله',
    'حي الأمير علي',
    'جبل الأمير حسن',
    'حي الأمير حمزة',
    'حي الأميرة رحمة',
    'حي جناعة',
    'إسكان الأمير هاشم تطوير النقب',
    'الفاخورة',
    'حي العراتفة',
    'الشمالي',
    'حي النزهة',
    'جبل طارق الحلايبة',
    'حي المصفاة',
    'حي الزواهرة'
],

            'العقبة' =>['
            مركز المدينة',
           'شاطئ الجنوب'
],


'المفرق' => [
    'المفرق',
    'أبو السوس',
    'أرينبة النعيمات',
    'أم الجمال',
    'أم النعام',
    'الخالدية',
    'الرحمات',
    'الرويشد',
    'الزهور',
    'السعيدية',
    'العاقب',
    'الكوم الأحمر',
    'بلعما',
    'بويضة الحوامده',
    'بويضة العليمات',
    'تل رماح',
    'حيان الرويبض',
    'خراب المطوي',
    'خربة السمرا',
    'خريسان',
    'خشاع القن',
    'خشاع سليتين',
    'خطلة',
    'رسم الحصان',
    'روضة أبو الهيال',
    'روضة الأمير حمزة',
    'روضة بسمة',
    'سبع أصير',
    'عمرة وعميرة',
    'كوم الرف',
    'نادرة',
    'نايفة',
    'هويشان'
],

'جرش' => [
    'جرش',
    'سوف',
    'ساكب',
    'كفر خل',
    'الكتة',
    'ريمون',
    'بليلا',
    'قفقفا',
    'نحلة',
    'الربوة',
    'دير الليات',
    'الحداده',
    'مقبله',
    'الكفير',
    'زقريط',
    'الجبارات',
    'عصفور',
    'الرشايدة',
    'ام رامح',
    'عنيبه',
    'جبا',
    'ام الزيتون',
    'النبي هود',
    'الحسينيات',
    'ام قنطرة',
    'نجدة',
    'المجر',
    'العبارة',
    'جملا',
    'قريع',
    'دبين',
    'الرياشي',
    'الحازية',
    'عمامه',
    'الشيخ مفرج',
    'السبطه',
    'ديرعجلون',
    'الجنيدية',
    'المشيرفة',
    'الفيحاء'
],

'مادبا' => [
    'مادبا',
    'المامونية',
    'الفيحاء',
    'الواحة',
    'الفالحة',
    'حوية البلاونة',
    'التيم',
    'الروابي',
    'الجبيل',
    'الهلالية'
],

    'السلط' => [
    'السلط',
    'زي',
    'أم جوزة',
    'الدير الشرقية',
    'اليزيدية',
    'يرقا',
    'إيرا',
    'آلان',
    'الرميمين',
    'مودري',
    'الزعتري',
    'حديب',
    'وادي عناقة',
    'ام خروبه',
    'وادي الصحن',
    'أم العمد',
    'الدعم',
    'السلوف',
    'جلعاد',
    'الوصية',
    'المشيرفة',
    'وادي شعيب'
],

       'الكرك' => [
  'الكرك' ,
    'ادر',
    'الشهابية',
    'منشية ابو حمور',
    'الجديدة',
    'راكين',
    'العدنانية',
    'الثنية',
    'بتير',
    'الغوير',
    'مدين',
    'سمرا',
    'مرود',
    'بذان وبردى',
    'البقيع',
    'زحوم',
    'المشيرفه',
    'عينون',
    'موميا',
    'وادي ابن حماد',
    'سكا',
    'الراشديه',
    'الوسيه',
    'المامونية',
    'الصالحية',
    'المحمودية',
    'ام رمانة',
    'العزيزية',
    'العباسية',
    'العبدلية',
    'اللجون',
    'قريفله',
    'الحويه',
    'كمله',
    'المريغه',
    'الزغرية'
],

   'الطفيلة' => [
       'الطفيله' ,
    'العين البيضا',
    'العيص، عيمة',
    'الحسين',
    'عابل',
    'النمتة',
    'أبو بنا',
    'شيظم',
    'السلع',
    'أرحاب',
    'اضباعة',
    'مجادل',
    'صوبميح',
    'عفرا',
    'عابور',
    'تلعة حسين',
    'المعطن',
    'البربيطة',
    'اللعبان'
],

   'معان' => [
       'معان',
    'المحطة',
    'دبة الكرم',
    'عقيقه',
    'الطاحونه',
    'العوينة',
    'البريكة',
    'المبروكة',
    'حطيه',
    'محطة الجرذانه'
],

       'عجلون' => [
           'عجلون',
    'عنجرة',
    'عين جنا',
    'الهاشمية',
    'الوهادنة',
    'حلاوة',
    'دير الصمادية الشمالي',
    'خشيبة الفوقا',
    'الجبل الاخضر',
    'الشكارة',
    'الفاخرة',
    'محنا,اشتفينا',
    'الطيارة',
    'ام الينابيع',
    'الساخنة,الحنش',
    'خربة السوق',
    'الزراعة',
    'كفر الدره',
    'الجب',
    'الحزار',
    'الزيزفونة',
    'السرابيس',
    'ام الخشب',
    'خلة سالم',
    'خلة وردة',
    'النقب',
    'عويمر',
    'الزعترة',
    'ابو الزيتون',
    'لستب',
    'الصفصافة',
    'دير الصمادية الجنوبي',
    'الصوان'
],

        ];

        foreach ($regions as $cityName => $regionNames) {
            $city = City::where('name', $cityName)->first();

            if ($city) { // تأكد من وجود المدينة
                foreach ($regionNames as $regionName) {
                    Region::create([
                        'name' => $regionName,
                        'city_id' => $city->id,
                    ]);
                }
            }
        }
    }
}
