<?php

namespace Database\Seeders;

use App\Models\Role;
use App\Models\Permission;
use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
    public function run(): void
    {
        // إنشاء دور سوبر ادمن
        $superAdminRole = Role::create([
            'name'         => 'superadmin',
            'display_name' => 'سوبر ادمن',
        ]); 

        // إنشاء دور أدمن
        $adminRole = Role::create([
            'name'         => 'admin',
            'display_name' => 'ادمن',
        ]);

        // ربط جميع الصلاحيات بكل من دور سوبر ادمن ودور أدمن
        $permissions = Permission::all()->pluck('id')->toArray();

        // ربط الصلاحيات بكل من الدورين
        $superAdminRole->permissions()->sync($permissions);
        $adminRole->permissions()->sync($permissions);
    }
}
