<?php

namespace Database\Seeders;

use App\Models\ThemeSettings;
use Illuminate\Database\Seeder;

class ThemeSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds to set up the theme settings.
     */
    public function run(): void
    {
        // تعريف مجموعات الألوان الجاهزة
        $colorSchemes = [
            'default' => [
                'name' => 'الافتراضي',
                'sidebar_bg_color' => '#1e1e2d',
                'header_bg_color' => '#ffffff',
                'primary_color' => '#009ef7',
                'secondary_color' => '#E4E6EF',
                'text_color' => '#3F4254',
                'link_color' => '#009ef7',
                'font_family' => 'Tajawal, Arial, sans-serif',
                'base_font_size' => '14px',
                'heading_font_size' => '1.25rem',
                'menu_font_size' => '1rem',
                'is_dark_mode' => false,
            ],
            'blue_gradient' => [
                'name' => 'تدرجات الأزرق',
                'sidebar_bg_color' => '#192841',
                'header_bg_color' => '#f8f9fa',
                'primary_color' => '#3a7bd5',
                'secondary_color' => '#D6E4F0',
                'text_color' => '#333333',
                'link_color' => '#3a7bd5',
                'font_family' => 'Cairo, Arial, sans-serif',
                'base_font_size' => '14px',
                'heading_font_size' => '1.3rem',
                'menu_font_size' => '1rem',
                'is_dark_mode' => false,
            ],
            'elegant_dark' => [
                'name' => 'الداكن الأنيق',
                'sidebar_bg_color' => '#121212',
                'header_bg_color' => '#1e1e1e',
                'primary_color' => '#bb86fc',
                'secondary_color' => '#444444',
                'text_color' => '#e0e0e0',
                'link_color' => '#bb86fc',
                'font_family' => 'Tajawal, Arial, sans-serif',
                'base_font_size' => '14px',
                'heading_font_size' => '1.25rem',
                'menu_font_size' => '1rem',
                'is_dark_mode' => true,
            ],
            'green_nature' => [
                'name' => 'الطبيعة الخضراء',
                'sidebar_bg_color' => '#1b3a27',
                'header_bg_color' => '#ffffff',
                'primary_color' => '#2e7d32',
                'secondary_color' => '#e8f5e9',
                'text_color' => '#2c3e50',
                'link_color' => '#2e7d32',
                'font_family' => 'Poppins, Arial, sans-serif',
                'base_font_size' => '14px',
                'heading_font_size' => '1.25rem',
                'menu_font_size' => '1rem',
                'is_dark_mode' => false,
            ],
            'purple_luxury' => [
                'name' => 'البنفسجي الفاخر',
                'sidebar_bg_color' => '#2c243b',
                'header_bg_color' => '#ffffff',
                'primary_color' => '#7b1fa2',
                'secondary_color' => '#f3e5f5',
                'text_color' => '#424242',
                'link_color' => '#7b1fa2',
                'font_family' => 'Cairo, Arial, sans-serif',
                'base_font_size' => '14px',
                'heading_font_size' => '1.25rem',
                'menu_font_size' => '1rem',
                'is_dark_mode' => false,
            ],
            'warm_gold' => [
                'name' => 'الذهبي الفاخر',
                'sidebar_bg_color' => '#000',
                'header_bg_color' => '#000',
                'primary_color' => '#e65100',
                'secondary_color' => '#fff3e0',
                'text_color' => '#424242',
                'link_color' => '#e65100',
                'font_family' => 'Tajawal, Arial, sans-serif',
                'base_font_size' => '14px',
                'heading_font_size' => '1.25rem',
                'menu_font_size' => '1rem',
                'is_dark_mode' => true,
            ],
        ];

        // حذف جميع البيانات الموجودة قبل إضافة البيانات الجديدة (اختياري)
        ThemeSettings::truncate();

        // إضافة نمط الألوان الافتراضي للنظام
        $defaultScheme = $colorSchemes['default'];
        unset($defaultScheme['name']); // إزالة الاسم لأنه غير موجود في جدول البيانات

        ThemeSettings::create($defaultScheme);

        // يمكن استخدام هذا الكود في حال أردنا تخزين مجموعات الألوان المختلفة في مكان آخر بالنظام
        // هذا التعليق فقط للإشارة إلى إمكانية توسيع هذه الوظيفة مستقبلاً
        /*
        foreach ($colorSchemes as $scheme) {
            unset($scheme['name']);
            ThemeSettings::create($scheme);
        }
        */
    }
}
