<?php

namespace Database\Seeders;

use App\Models\Room;
use App\Models\User;
use Illuminate\Database\Seeder;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        // التأكد من وجود الغرفة
        Room::create(['name' => 'Room 1', 'room_code' => 1], ['name' => 'Room 2', 'room_code' => 2], ['name' => 'Room 3', 'room_code' => 3]); // إضافة الغرفة إذا لم تكن موجودة

        // إنشاء المستخدم
        $user = User::create([
            'name'     => 'محمود احمد',
            'email'    => 'm@gmail.com',
            'password' => bcrypt('password'),
            'phone'    => '01118759692',
            'address'  => 'بنى سويف',
            'room_code'  => 1, // ربط المستخدم بالغرفة رقم 1
        ]);

        // إضافة دور للمستخدم
        $user->addRole('superadmin'); 

        // إنشاء المستخدم
        $user2 = User::create([
            'name'     => 'احمد البطل',
            'email'    => 'elbatal@gmail.com',
            'password' => bcrypt('password'),
            'phone'    => '01021512341',
            'address'  => 'بنى سويف',
            'room_code'  => 1, // ربط المستخدم بالغرفة رقم 1
        ]);

        // إضافة دور للمستخدم
        $user2->addRole('admin');
    }
}
