<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\WhatsAppTemplate;

class WhatsAppTemplateSeeder extends Seeder
{
    public function run()
    {
        // Existing Templates
        WhatsAppTemplate::create([
            'name' => 'إنشاء فحص جديد',
            'code' => 'add_examination',
            'message' => 'عزيزي العميل {name}، تم إنشاء الفحص الخاص بك برمز {examination_number} بتاريخ {date}. يرجى التوجه إلى قسم الاستقبال لإتمام الفحص. شكراً لك، مركز سمير للبصريات.',
        ]);

        WhatsAppTemplate::create([
            'name' => 'تأكيد الفحص من الاستقبال',
            'code' => 'reception_confirmation',
            'message' => 'عزيزي العميل {name}، نود إعلامك بأن الفحص الخاص بك برقم {examination_number} الذي تم تسجيله بتاريخ {date} قد تم إرساله إلى المشغل وهو الآن قيد التنفيذ. شكراً لك، مركز سمير للبصريات.',
        ]);

        WhatsAppTemplate::create([
            'name' => 'بانتظار التسليم',
            'code' => 'examination_pending_delivery',
            'message' => 'عزيزي العميل {name}، تم الانتهاء من {type} الخاص بك. يرجى التوجه إلى قسم الاستلام في المركز لاستلام الفحص. شكراً لك، مركز الدكتور سمير للبصريات.',
        ]);

        WhatsAppTemplate::create([
            'name' => 'تم التسليم',
            'code' => 'examination_delivered',
            'message' => 'عزيزي العميل {name}، تم استلام {type} بنجاح. شكراً لك، مركز الدكتور سمير للبصريات.',
        ]);

        WhatsAppTemplate::create([
            'name' => 'إلغاء الفحص',
            'code' => 'examination_cancelled',
            'message' => 'عزيزي العميل {name}، نود إعلامك بأن الفحص الخاص بك برقم {examination_number} الذي تم تسجيله بتاريخ {date} قد تم إلغاؤه. نعتذر عن أي إزعاج قد يسببه هذا. شكراً لك، مركز سمير للبصريات.',
        ]);

        // New Reminder Templates
        WhatsAppTemplate::create([
            'name' => 'تذكير فحص للفئة العمرية من 6 إلى 18 سنة',
            'code' => 'reminder_age_6_to_18',
            'message' => 'عزيزي العميل {name}، نود تذكيرك بأن الفحص الخاص بك برمز {examination_number} يحتاج إلى متابعة دورية. يُرجى تحديد موعد جديد لإتمام الفحص. شكراً لك، مركز سمير للبصريات.',
            'age_range' => [6, 18], // Example range (6 to 15 years)
            'months' => [3],       // Example duration (3 months)
        ]);

        WhatsAppTemplate::create([
            'name' => 'تذكير فحص للفئة العمرية من 18 إلى 25 سنة',
            'code' => 'reminder_age_18_to_25',
            'message' => 'عزيزي العميل {name}، لقد مر 6 أشهر على الفحص الخاص بك برقم {examination_number}. يُرجى تحديد موعد جديد لإتمام الفحص. شكراً لك، مركز سمير للبصريات.',
            'age_range' => [18, 25], // Example range (18 to 25 years)
            'months' => [6],         // Example duration (6 months)
        ]);

        WhatsAppTemplate::create([
            'name' => 'تذكير فحص للفئة العمرية من 25 سنة فأكثر',
            'code' => 'reminder_age_25_and_above',
            'message' => 'عزيزي العميل {name}، لقد مر 6 أشهر على الفحص الخاص بك برقم {examination_number}. يُرجى تحديد موعد جديد لإتمام الفحص. شكراً لك، مركز سمير للبصريات.',
            'age_range' => [25, null], // Example range (25 years and above)
            'months' => [6],           // Example duration (6 months)
        ]);
    }
}
