@extends('admin.layouts.main')
@section('title')
    {{ __('translations.examinations-create') }}
@endsection
@section('sub-title')
    {{ __('translations.examinations') }}
@endsection
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-docs mb-2">
                            <div class="card-header">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0">{{ __('translations.examinations-create') }}</h3>
                                </div>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('admin.examinations.store') }}" method="post"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6 mb-5">
                                            <label class="form-label">{{ __('translations.Examination Code') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="code"
                                                value="{{ $examination_code }}" readonly />
                                            @error('code')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>

                                        <div class="col-md-6 mb-5">
                                            <label class="form-label">{{ __('translations.Client name') }} <span
                                                    class="text-danger">*</span></label>
                                            <select class="form-control" data-control="select2" name="client_id" required>
                                                <option value="" disabled selected>
                                                    {{ __('translations.select_client') }}</option>
                                                @if (is_countable($clients) && count($clients) > 0)
                                                    @foreach ($clients as $client)
                                                        <option value="{{ $client->id }}">
                                                            {{ $client->first_name . ' ' . $client->last_name }}</option>
                                                    @endforeach
                                                @else
                                                    <option value="">{{ __('translations.no_clients') }}</option>
                                                @endif
                                            </select>
                                            @error('client_id')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>


                                        <div class="col-md-6 mb-5">
                                            <label class="form-label">{{ __('translations.type') }} <span
                                                    class="text-danger">*</span></label>
                                            <select class="form-control" data-control="select2" name="type" required>
                                                <option value="" disabled selected>
                                                    {{ __('translations.select_type') }}</option>
                                                @if (is_countable($types) && count($types) > 0)
                                                    @foreach ($types as $type)
                                                        <option value="{{ $type }}">{{ $type }}</option>
                                                    @endforeach
                                                @else
                                                    <option value="">{{ __('translations.no_types') }}</option>
                                                @endif
                                            </select>
                                            @error('type')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>



                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.Note') }} <span
                                                    class="text-danger">*</span></label>
                                            <textarea class="form-control" name="notes" rows="5" ></textarea>
                                            @error('notes')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>
                                        <div class="col-md-6 mb-5">

                                            <input type="text" class="form-control" name="status"
                                                value='في انتظار التاكيد' hidden />
                                            @error('status')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>



                                        <div class="card-body" dir="ltr">

                                            <table
                                                class="table align-middle table-row-dashed fs-6 gy-5 custom-table d-table">
                                                <thead>
                                                    <tr class="fw-bolder fs-8 text-uppercase gs-0">

                                                        <th>type</th>
                                                        <th>Sph</th>
                                                        <th>Cyl</th>
                                                        <th>Axis</th>
                                                        <th>L.P.D</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="text-gray-800 fw-bold">
                                                    <tr>
                                                        <td>Rt</td>
                                                        <td>--</td>
                                                        <td>--</td>
                                                        <td>--</td>
                                                        <td>--</td>
                                                    </tr>
                                                    <tr>
                                                        <td>Lt</td>
                                                        <td>--</td>
                                                        <td>--</td>
                                                        <td>--</td>
                                                        <td>--</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>


                                        <div class="d-flex pt-5 justify-content-between align-items-center">
                                            <a href="{{ route('admin.examinations.index') }}" class="btn btn-secondary">
                                                {{ __('translations.back') }} <i class="fa fa-undo" aria-hidden="true"></i>
                                            </a>
                                            <button type="submit" class="btn btn-primary">
                                                {{ __('translations.create') }} <i class="fa fa-check"
                                                    aria-hidden="true"></i>
                                            </button>
                                        </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
