@extends('admin.layouts.main')
@section('title')
  {{ __('translations.cancelled-list') }}
@endsection
@section('sub-title')
  {{ __('translations.cancelled') }}
@endsection
@section('content')
  <style>
    /* تنسيق الفحص المميز */
    .special-examination {
      background-color: #fff4e1;
      /* خلفية لون أصفر ناعم */
      border-left: 5px solid #ff5722;
      /* شريط برتقالي على الجهة اليسرى */
      color: #6c6c6c;
      /* لون النص ليتناسب مع الخلفية */
      font-weight: bold;
      /* جعل النص ثقيل لجذب الانتباه */
    }

    /* تنسيق الأعمدة داخل الصف المميز */
    .special-examination td {
      padding: 12px 15px;
      /* إضافة حواف داخلية للصف */
    }

    /* تنسيق زر "عرض" */
    .special-examination .btn {
      background-color: #ff9800;
      /* لون الزر برتقالي */
      color: #fff;
      /* نص الزر باللون الأبيض */
      border: none;
      padding: 6px 12px;
      font-weight: bold;
      border-radius: 4px;
    }

    .special-examination .btn:hover {
      background-color: #e65100;
      /* تغيير لون الزر عند التمرير */
      color: #fff;
    }
  </style>

  <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
      <div id="kt_content_container" class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card card-docs mb-2">
              <div class="card-header">
                <div class="card-title m-0">
                  <h3 class="fw-bolder m-0">{{ __('translations.cancelled-list') }}</h3>
                </div>

              </div>
              <div class="card-body">
                <div class="d-flex align-items-center position-relative mb-4">
                  <span class="svg-icon svg-icon-1 position-absolute ms-4">
                    <svg width="18" height="18" viewBox="0 0 24 24">
                      <path fill="currentColor"
                        d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0 0 16 9.5A6.5 6.5 0 1 0 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14z" />
                    </svg>
                  </span>
                  <input type="text" data-kt-filter="search" class="form-control form-control-solid w-250px ps-14"
                    placeholder="{{ __('translations.cancelled-search') }}" />
                </div>
                @php
                  $specialColors = [
                      'عادي' => '#FFFFFF', // Default white background
                      'مميز' => '#FFFACD', // Light yellow for special
                      'مستعجل' => '#FFDAB9', // Peach for urgent
                      'تحضير' => '#E0FFE0', // Light green for preparation
                      'توصيل' => '#ADD8E6', // Light blue for delivery
                  ];

                  $statusLabelColors = [
                      'عادي' => 'secondary',
                      'مميز' => 'warning',
                      'مستعجل' => 'danger',
                      'تحضير' => 'success',
                      'توصيل' => 'info',
                  ];
                @endphp

                <table id="kt_datatable_example"
                  class="table align-middle table-row-dashed fs-6 gy-5 custom-table d-table">
                  <thead>
                    <tr class="fw-bolder fs-8 text-uppercase gs-0">
                      <th>{{ __('translations.Examination Code') }}</th>
                      <th>{{ __('translations.Client name') }}</th>
                      <th>{{ __('translations.Note') }}</th>
                      <th>{{ __('translations.type') }}</th>
                      <th>{{ __('translations.Date') }}</th>
                      <th>{{ __('translations.actions') }}</th>
                    </tr>
                  </thead>
                  <tbody class="text-gray-800 fw-bold">
                    @foreach ($examinations as $examination)
                      @php
                        $rowColor = $specialColors[$examination->special] ?? '#FFFFFF'; // Default to white
                        $labelClass = $statusLabelColors[$examination->special] ?? 'secondary'; // Default label class
                      @endphp
                      <tr style="background-color: {{ $rowColor }};">
                        <td>{{ $examination->code }}</td>
                        <td>{{ $examination->client->first_name ?? '' }} {{ $examination->client->last_name ?? '' }}</td>
                        <td>{!! \Illuminate\Support\Str::limit($examination->notes, 100, '...') !!}</td>
                        <td>{{ $examination->type }}</td>
                        <td>{{ $examination->created_at }}</td>
                        <td>
                          <div style="display: flex; align-items: center; justify-content: space-between;">
                            @permission('receptions-show')
                              <a href="{{ route('admin.cancelled.show', $examination->id) }}"
                                class="btn btn-light btn-active-light-primary btn-sm">
                                {{ __('translations.show') }}
                              </a>
                            @endpermission

                            <!-- Status label -->
                            <span class="badge badge-{{ $labelClass }}" style="margin-left: 10px;">
                              {{ $examination->special }}
                            </span>
                          </div>
                        </td>
                      </tr>
                    @endforeach
                  </tbody>
                </table>

              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
@endsection
