<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $setting->name }} </title>

    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            background: #f9f9f9;
            color: #333;
        }

        .container {
            max-width: 800px;
            margin: auto;
            background: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            position: relative;
            background-color: #fff;
            opacity: 0.9;
        }

        .container::before {
            content: "";
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-10deg);
            background-image: url('{{ asset('uploads/' . $setting->logo) }}');
            background-position: center;
            background-repeat: no-repeat;
            background-size: 100% 100%;
            width: 100%;
            height: 100%;
            opacity: 0.1;
            pointer-events: none;
            z-index: -1;
        }

        .section {
            margin-bottom: 20px;
        }

        .section h2 {
            font-size: 1.4rem;
            color: #333;
            margin-bottom: 10px;
            border-bottom: 1px solid #ccc;
            padding-bottom: 5px;
        }

        .details-list {
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            padding: 0;
            margin: 0;
        }

        .details-item {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            font-size: 1rem;
        }

        .details-item span {
            display: inline-block;
            color: #555;
        }

        .details-item .title {
            font-weight: bold;
            color: #333;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        table th,
        table td {
            border: 1px solid #ccc;
            padding: 10px;
            text-align: center;
            font-size: 1rem;
        }

        table th {
            background: #f7f7f7;
            color: #333;
        }

        .footer {
            text-align: center;
            font-size: 1.1rem;
            color: #555;
            margin-top: 40px;
            padding-top: 10px;
            border-top: 1px solid #ccc;
            padding-bottom: 10px;
        }

        .footer p {
            margin: 0;
        }

        .footer .heart {
            color: #e74c3c;
            font-size: 1.2rem;
        }

        @media print {
            body {
                font-family: 'Arial', sans-serif;
                margin: 0;
                padding: 0;
                background: #f9f9f9;
                color: #333;
            }

            .container {
                max-width: 800px;
                margin: auto;
                background: #fff;
                padding: 20px;
                box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
                border-radius: 8px;
                position: relative;
                background-color: #fff;
                opacity: 0.9;
            }

            .footer {
                display: block;
                font-size: 1.2rem;
                color: #555;
                margin-top: 20px;
                padding-top: 10px;
                border-top: 1px solid #ccc;
                text-align: center;
            }

            .footer .heart {
                font-size: 1.5rem;
                color: #e74c3c;
            }

        }
    </style>
</head>

<body dir="rtl">
    <div class="container">

        <div class="section">
            <div class="logo" style="text-align: left;">
                <span>
                    <img style="width: 80px; height: 50px;" src="{{ asset('uploads/' . $setting->logo) }}"
                        alt="logo">
                </span>
            </div>
            <ul class="details-list">
                <li class="details-item">
                    <span style="font-size: 30px">{{ $examination->code }}</span>
                </li>
                <li class="details-item">
                    <span style="font-size: 30px">{{ $examination->client->first_name }}
                        {{ $examination->client->last_name }}</span>
                </li>
            </ul>
            <div class="details-item" style="display: block;">
                <span class="title" style="font-size: 20px">{{ __('translations.type') }}: </span>
                <span style="font-size: 20px">{{ $examination->type }}</span>
            </div>
        </div>

        <div class="section">
            <div style="display: flex; gap: 0;">
                <div style="flex: 0 0 30%; margin-left: -1px;">
                    <table class="table table-bordered" dir="ltr">
                        <tbody>
                            <tr>
                                <td style="width: 50%"></td>
                                <td style="width: 50%">{{ __('translations.price') }}</td>
                            </tr>
                            <tr>
                                <td style="width: 50%"></td>
                                <td style="width: 50%">{{ __('translations.paid') }}</td>
                            </tr>
                            <tr>
                                <td style="width: 50%"></td>
                                <td style="width: 50%">{{ __('translations.remaining') }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div style="flex: 1;">
                    <table class="table table-bordered" dir="ltr">
                        <thead>
                            <tr>
                                <th>{{ __('translations.Type') }}</th>
                                <th>{{ __('translations.Sph') }}</th>
                                <th>{{ __('translations.Cyl') }}</th>
                                <th>{{ __('translations.Axis') }}</th>
                                <th>{{ __('translations.I.P.D') }}</th>
                                <th>{{ __('translations.A.D.D') }}</th>
                            </tr>
                        </thead>
                        <tbody id="details-table-body">
                            @foreach ($examination->details as $item)
                                <tr>
                                    <td>{{ $item->type }}</td>
                                    <td>{{ $item->sph }}</td>
                                    <td>{{ $item->cyl }}</td>
                                    <td>{{ $item->axis }}</td>
                                    <td>{{ $item->add }}</td>
                                    <td>{{ $item->lpd }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>

    <script>
        window.onload = function() {
            setTimeout(() => {
                window.print();
            }, 1000); // يتم تأخير الطباعة لمدة 1 ثانية بعد تحميل الصفحة
        };
    </script>

</body>

</html>
