@extends('admin.layouts.main')

@section('title')
    {{ __('translations.examinations-show') }}
@endsection

@section('sub-title')
    {{ __('translations.examinations') }}
@endsection

@section('content')
    <style>
        .details-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 2rem;
            font-size: 1.2rem;
            padding: 0.8rem 1.2rem;
            border: 1px solid #eee;
            border-radius: 8px;
            background-color: #f9f9f9;
        }

        .details-title {
            font-weight: bold;
            color: #333;
        }

        .details-value {
            font-weight: 600;
            color: #3a3a3a;
        }

        .table th,
        .table td {
            font-size: 1.1rem;
            text-align: center;
        }

        .select-status {
            font-size: 1rem;
            padding: 0.5rem;
            border-radius: 6px;
            border: 1px solid #ccc;
            color: #333;
        }

        @media print {
            header,
            .navbar,
            .card-header,
            .footer {
                display: none;
            }

            .btn,
            .card-body>.d-flex,
            .card-title {
                display: none;
            }

            .card-body {
                font-size: 1.2rem;
                line-height: 1.6;
            }

            .table th,
            .table td {
                font-size: 1rem;
                text-align: left;
            }

            .details-item {
                padding: 1rem;
                margin-bottom: 1rem;
            }

            .select-status {
                border: none;
                outline: none;
                background: none;
            }
        }
    </style>

    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-docs mb-2">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h3 class="fw-bolder m-0">{{ __('translations.examination_details') }}</h3>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-2">
                                        <div class="details-item">
                                            <span class="details-title">{{ __('translations.Examination Code') }}</span>
                                            <span class="details-value">{{ $examination->code }}</span>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="details-item">
                                            <span class="details-title">{{ __('translations.Client name') }}</span>
                                            <span class="details-value">{{ $examination->client->first_name }} {{ $examination->client->last_name }}</span>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="details-item">
                                            <span class="details-title">{{ __('translations.phone') }}</span>
                                            <span class="details-value">{{ $examination->client->phone }}</span>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="details-item">
                                            <span class="details-title">{{ __('translations.type') }}</span>
                                            <span class="details-value">{{ $examination->type }}</span>
                                        </div>
                                    </div>


                                    <div class="col-md-4">
                                        <div class="details-item">
                                            <span class="details-title">{{ __('translations.status') }}</span>
                                            <span class="details-value">
                                                @if(!empty($examination->status) && $examination->status == 'الغاء')
                                                    <span>{{ __('translations.cancelledd') }}</span>
                                                @else
                                                    <span>تحديث الحالة</span>
                                                @endif
                                            </span>
                                        </div>
                                    </div>

                                    <div class="col-md-9">
                                        <div>
                                            <span class="details-title">{{ __('translations.Note') }} : {{ $examination->notes }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="card-body">
                                    <h5 class="mb-3">{{ __('translations.Examination Results') }}</h5>
                                    <table class="table align-middle table-row-dashed fs-6 gy-5 custom-table d-table">
                                        <thead>
                                            <tr class="fw-bolder fs-8 text-uppercase gs-0">
                                                <th>{{ __('translations.Type') }}</th>
                                                <th>{{ __('translations.Sph') }}</th>
                                                <th>{{ __('translations.Cyl') }}</th>
                                                <th>{{ __('translations.Axis') }}</th>
                                                <th>{{ __('translations.A.D.D') }}</th>
                                                <th>{{ __('translations.I.P.D') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody id="details-table-body" class="text-gray-800 fw-bold">
                                            @foreach ($examination->details as $item)
                                                <tr>
                                                    <td>{{ $item->type }}</td>
                                                    <td>{{ $item->sph }}</td>
                                                    <td>{{ $item->cyl }}</td>
                                                    <td>{{ $item->axis }}</td>
                                                    <td>{{ $item->add }}</td>
                                                    <td>{{ $item->lpd }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                <div class="d-flex pt-5 justify-content-between align-items-center">
                                    <a href="{{ route('admin.cancelled.index') }}" class="btn btn-secondary">
                                        {{ __('translations.back') }} <i class="fa fa-undo"></i>
                                    </a>
                                    <a href="{{ route('admin.cancelled.print', $examination->id) }}" class="btn btn-primary" target="_blank">
                                        {{ __('translations.print') }} <i class="fa fa-print"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
