@extends('admin.layouts.main')
@section('title'){{ __('translations.update-status') }}@endsection
@section('sub-title'){{ __('translations.update-status') }}@endsection

@section('content')
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
  <div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-fluid">
      <div class="row">
        <div class="col-12">
          <div class="card card-docs mb-2">
            <div class="card-header">
              <div class="card-title m-0">
                <h3 class="fw-bolder m-0">{{ __('translations.update-status') }}</h3>
              </div>
            </div>
            <div class="card-body">
              <form action="{{ route('admin.receptions.update-status.submit', $examination->id) }}" method="post">
                @csrf
                @method('POST')

                <div class="col-md-6 mb-5">
                  <label class="form-label">{{ __('translations.status') }} <span class="text-danger">*</span></label>
                  <select class="form-control" data-control="select2" name="status" required>
                    @foreach ($statuses as $status)
                      <option value="{{ $status }}" {{ $examination->status == $status ? 'selected' : '' }}>
                        {{ $status }}
                      </option>
                    @endforeach
                  </select>
                </div>

                <div class="d-flex pt-5 justify-content-between align-items-center">
                  <a href="{{ route('admin.receptions.index') }}" class="btn btn-secondary">
                    {{ __('translations.back') }} <i class="fa fa-undo" aria-hidden="true"></i>
                  </a>
                  <button type="submit" class="btn btn-primary">
                    {{ __('translations.update') }} <i class="fa fa-check" aria-hidden="true"></i>
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
