@extends('admin.layouts.main')
@section('title')
    {{ __('translations.clients-create') }}
@endsection
@section('sub-title')
    {{ __('translations.clients') }}
@endsection

<head>
    <!-- تحميل CSS لـ Select2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <style>
        .card-docs {
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08) !important;
            border: none;
        }
        .card-header {
            border-radius: 12px 12px 0 0 !important;
            background-color:var(--sidebar-bg-color) !important;
        }
        .card-title h3 {
            color: #ffffff !important;
            font-weight: 600 !important;
        }
        .form-control-solid, .form-select-solid {
            border-radius: 8px;
            border: 1px solid #e5e7eb;
            transition: all 0.3s;
        }
        .form-control-solid:focus, .form-select-solid:focus {
            border-color: #4e4376;
            box-shadow: 0 0 0 3px rgba(78, 67, 118, 0.1);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(78, 67, 118, 0.2);
        }
        .btn-light {
            background: #f8fafc;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 10px 20px;
            transition: all 0.3s;
        }
        .btn-light:hover {
            background: #f1f5f9;
            transform: translateY(-2px);
        }
        .section-title {
            position: relative;
            display: inline-block;
            padding-left: 18px;
        }
        .section-title:before {
            content: "";
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            width: 8px;
            height: 25px;
            background: linear-gradient(135deg, #2b5876, #4e4376);
            border-radius: 4px;
        }
        .input-icon {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #6b7280;
        }
        .input-group-prepend {
            margin-right: -1px;
        }
        .form-group {
            position: relative;
        }
        .phone-input-container {
            display: flex;
            align-items: stretch;
        }
        .phone-input-container .country-select {
            min-width: 140px;
            border-radius: 8px 0 0 8px !important;
        }
        .phone-input-container .phone-input {
            border-radius: 0 8px 8px 0 !important;
            flex-grow: 1;
        }
        .flag-icon {
            width: 20px;
            margin-right: 5px;
        }
    </style>
</head>

@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-xxl">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-docs mb-5">
                            <div class="card-header">
                                <div class="card-title m-0">
                                    <h3 class="fw-bold m-0">
                                        <i class="fa fa-user-plus me-2"></i>
                                        {{ __('translations.clients-create') }}
                                    </h3>
                                </div>
                            </div>

                            <div class="card-body p-lg-5">
                                <form action="{{ route('admin.clients.store') }}" method="post" enctype="multipart/form-data">
                                    @csrf

                                    <!-- Personal Information -->
                                    <div class="mb-5">
                                        <h4 class="fs-5 fw-semibold mb-3 text-gray-700 section-title">
                                            {{ __('translations.Client Information') }}
                                        </h4>
                                        <div class="separator separator-dashed mb-4"></div>

                                        <div class="row">
                                            <div class="col-md-6 mb-4">
                                                <label class="form-label fw-semibold">
                                                    <i class="fa fa-id-card text-primary me-2"></i>
                                                    {{ __('translations.first name') }} <span class="text-danger">*</span>
                                                </label>
                                                <div class="position-relative">
                                                    <input type="text" class="form-control form-control-solid ps-3" name="first_name" required />
                                                </div>
                                                @error('first_name')
                                                    <div class="fv-plugins-message-container invalid-feedback mt-1">
                                                        <strong>{{ $message }}</strong>
                                                    </div>
                                                @enderror
                                            </div>

                                            <div class="col-md-6 mb-4">
                                                <label class="form-label fw-semibold">
                                                    <i class="fa fa-user text-primary me-2"></i>
                                                    {{ __('translations.last name') }} <span class="text-danger">*</span>
                                                </label>
                                                <div class="position-relative">
                                                    <input type="text" class="form-control form-control-solid ps-3" name="last_name" required />
                                                </div>
                                                @error('last_name')
                                                    <div class="fv-plugins-message-container invalid-feedback mt-1">
                                                        <strong>{{ $message }}</strong>
                                                    </div>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6 mb-4">
                                                <label class="form-label fw-semibold">
                                                    <i class="fa fa-phone-alt text-primary me-2"></i>
                                                    {{ __('translations.phone') }} <span class="text-danger">*</span>
                                                </label>
                                                <div class="phone-input-container">
                                                    <select id="country_code" class="form-select form-select-solid country-select" data-control="select2" name="country_code" required>
                                                        <option value="" disabled>{{ __('translations.SelectCountryCode') }}</option>
                                                        @foreach ($countries as $country)
                                                            <option {{ $country->phone == '+962' ? 'selected' : ' ' }} value="{{ $country->phone }}">
                                                                {{ $country->name_ar }} ({{ $country->phone }})
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    <input type="text" class="form-control form-control-solid phone-input" placeholder="{{ __('translations.phone') }}" name="phone" required />
                                                </div>
                                                @error('phone')
                                                    <div class="fv-plugins-message-container invalid-feedback mt-1">
                                                        <strong>{{ $message }}</strong>
                                                    </div>
                                                @enderror
                                            </div>

                                            <div class="col-md-3 mb-4">
                                                <label class="form-label fw-semibold">
                                                    <i class="fa fa-birthday-cake text-primary me-2"></i>
                                                    {{ __('translations.age') }} <span class="text-danger">*</span>
                                                </label>
                                                <div class="position-relative">
                                                    <input type="number" placeholder="{{ __('translations.age') }}" class="form-control form-control-solid" name="age" required />
                                                </div>
                                                @error('age')
                                                    <div class="fv-plugins-message-container invalid-feedback mt-1">
                                                        <strong>{{ $message }}</strong>
                                                    </div>
                                                @enderror
                                            </div>

                                            <div class="col-md-3 mb-4">
                                                <label class="form-label fw-semibold">
                                                    <i class="fa fa-venus-mars text-primary me-2"></i>
                                                    {{ __('translations.Gender') }} <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-select form-select-solid" name="gender" required>
                                                    <option value="">{{ __('translations.Gender') }}</option>
                                                    <option value="man">{{ __('translations.man') }}</option>
                                                    <option value="woman">{{ __('translations.women') }}</option>
                                                </select>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 mb-4">
                                                    <label class="form-label fw-semibold">
                                                        <i class="fa fa-map-marker-alt text-primary me-2"></i>
                                                        {{ __('translations.City') }} <span class="text-danger">*</span>
                                                    </label>
                                                    <select class="form-select form-select-solid" name="city_id" id="city_id">
                                                        <option value="">{{ __('translations.SelectCity') }}</option>
                                                        @foreach ($cities as $city)
                                                            <option value="{{ $city->id }}">
                                                                {{ $city->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    @error('city_id')
                                                        <div class="fv-plugins-message-container invalid-feedback mt-1">
                                                            <strong>{{ $message }}</strong>
                                                        </div>
                                                    @enderror
                                                </div>

                                                <div class="col-md-6 mb-4">
                                                    <label class="form-label fw-semibold">
                                                        <i class="fa fa-map text-primary me-2"></i>
                                                        {{ __('translations.Region') }} <span class="text-danger">*</span>
                                                    </label>
                                                    <select class="form-select form-select-solid" name="region_id" id="region_id">
                                                        <option value="">{{ __('translations.SelectRegion') }}</option>
                                                    </select>
                                                    @error('region_id')
                                                        <div class="fv-plugins-message-container invalid-feedback mt-1">
                                                            <strong>{{ $message }}</strong>
                                                        </div>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="d-flex pt-3 border-top justify-content-between align-items-center">
                                        <a href="{{ route('admin.index') }}" class="btn btn-light">
                                            <i class="fa fa-arrow-left me-1"></i> {{ __('translations.back') }}
                                        </a>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fa fa-check-circle me-1"></i> {{ __('translations.create') }}
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // تهيئة Select2
            if (typeof $.fn.select2 !== 'undefined') {
                $('.form-select').select2({
                    minimumResultsForSearch: 10,
                    dropdownCssClass: "select2-dropdown-bordered"
                });
            }

            // Load regions when city changes
            $('#city_id').on('change', function() {
                var cityId = $(this).val();
                var regionSelect = $('#region_id');

                // Clear current regions
                regionSelect.empty().append('<option value="">{{ __("translations.SelectRegion") }}</option>');

                if(cityId) {
                    // Fetch regions for the selected city
                    $.ajax({
                        url: '/admin/cities/' + cityId + '/regions',
                        type: 'GET',
                        dataType: 'json',
                        success: function(data) {
                            $.each(data, function(key, region) {
                                regionSelect.append('<option value="' + region.id + '">' + region.name + '</option>');
                            });
                            regionSelect.trigger('change');
                        }
                    });
                }
            });
        });
    </script>
@endsection
