@extends('admin.layouts.main')

@section('title')
    {{ __('translations.settings') }}
@endsection

@section('sub-title')
    {{ __('translations.whatsapp templates') }}
@endsection

@section('content')
<div class="container mt-5">
    <h1 class="text-center">Cron Job Settings</h1>
    <p class="text-muted text-center">Configure your server to run scheduled tasks automatically.</p>

    <div class="card mt-4">
        <div class="card-body">
            <h5 class="card-title">Server Cron Job Configuration</h5>
            <p class="card-text">
                To enable automatic execution of scheduled tasks, set the following cron job on your server:
            </p>

            <div class="alert alert-primary" role="alert">
                <code>{{ $cronCommand }}</code>
            </div>

            <h6 class="mt-4">Steps to Add Cron Job</h6>
            <ol>
                <li>Log in to your server via SSH.</li>
                <li>Run the command: <code>crontab -e</code> to edit the cron jobs.</li>
                <li>Add the following line to the crontab file:
                    <br>
                    <div class="alert alert-secondary mt-2">
                        <code>{{ $cronCommand }}</code>
                    </div>
                </li>
                <li>Save the file and exit.</li>
            </ol>
        </div>
    </div>

    <div class="card mt-4">
        <div class="card-body">
            <h5 class="card-title">Verify Cron Job is Running</h5>
            <p class="card-text">You can verify that your cron job is running by checking the Laravel logs:</p>
            <ul>
                <li>Log file: <code>storage/logs/laravel.log</code></li>
                <li>Look for entries related to your scheduled tasks.</li>
            </ul>
        </div>
    </div>
</div>
@endsection
